% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIfitHMM.R
\name{MIfitHMM}
\alias{MIfitHMM}
\title{Fit HMMs to multiple imputation data}
\usage{
MIfitHMM(miData, nSims, ncores = 1, poolEstimates = TRUE, alpha = 0.95,
  nbStates, dist, Par0, beta0 = NULL, delta0 = NULL, estAngleMean = NULL,
  circularAngleMean = NULL, formula = ~1, formulaDelta = ~1,
  stationary = FALSE, verbose = NULL, nlmPar = NULL, fit = TRUE,
  useInitial = FALSE, DM = NULL, cons = NULL, userBounds = NULL,
  workBounds = NULL, workcons = NULL, stateNames = NULL,
  knownStates = NULL, fixPar = NULL, retryFits = 0, retrySD = NULL,
  optMethod = "nlm", control = list(), prior = NULL, covNames = NULL,
  spatialCovs = NULL, centers = NULL, centroids = NULL,
  angleCovs = NULL, method = "IS", parIS = 1000, dfSim = Inf,
  grid.eps = 1, crit = 2.5, scaleSim = 1, force.quad = TRUE,
  fullPost = TRUE, dfPostIS = Inf, scalePostIS = 1, thetaSamp = NULL)
}
\arguments{
\item{miData}{A \code{\link{crwData}} object, a \code{\link{crwSim}} object, or a list of \code{\link{momentuHMMData}} objects.}

\item{nSims}{Number of imputations in which to fit the HMM using \code{\link{fitHMM}}. If \code{miData} is a list of \code{momentuHMMData} 
objects, \code{nSims} cannot exceed the length of \code{miData}.}

\item{ncores}{Number of cores to use for parallel processing. Default: 1 (no parallel processing).}

\item{poolEstimates}{Logical indicating whether or not to calculate pooled parameter estimates across the \code{nSims} imputations using \code{\link{MIpool}}. Default: \code{TRUE}.}

\item{alpha}{Significance level for calculating confidence intervals of pooled estimates when \code{poolEstimates=TRUE} (see \code{\link{MIpool}}). Default: 0.95.}

\item{nbStates}{Number of states of the HMM. See \code{\link{fitHMM}}.}

\item{dist}{A named list indicating the probability distributions of the data streams. See \code{\link{fitHMM}}.}

\item{Par0}{A named list containing vectors of initial state-dependent probability distribution parameters for 
each data stream specified in \code{dist}. See \code{\link{fitHMM}}.  \code{Par0} may also be a list of length \code{nSims}, where each element is a named list containing vectors
of initial state-dependent probability distribution parameters for each imputation. Note that if \code{useInitial=TRUE} then \code{Par0} is ignored after the first imputation.}

\item{beta0}{Initial matrix of regression coefficients for the transition probabilities. See \code{\link{fitHMM}}. \code{beta0} may also be a list of length \code{nSims}, where each element 
is an initial matrix of regression coefficients for the transition probabilities for each imputation.}

\item{delta0}{Initial values for the initial distribution of the HMM. See \code{\link{fitHMM}}. \code{delta0} may also be a list of length \code{nSims}, where each element 
is the initial values for the initial distribution of the HMM for each imputation.}

\item{estAngleMean}{An optional named list indicating whether or not to estimate the angle mean for data streams with angular 
distributions ('vm' and 'wrpcauchy'). See \code{\link{fitHMM}}.}

\item{circularAngleMean}{An optional named list indicating whether to use circular-linear (FALSE) or circular-circular (TRUE) 
regression on the mean of circular distributions ('vm' and 'wrpcauchy') for turning angles. See \code{\link{fitHMM}}.}

\item{formula}{Regression formula for the transition probability covariates. See \code{\link{fitHMM}}.}

\item{formulaDelta}{Regression formula for the initial distribution. See \code{\link{fitHMM}}.}

\item{stationary}{\code{FALSE} if there are covariates. If \code{TRUE}, the initial distribution is considered
equal to the stationary distribution. See \code{\link{fitHMM}}.}

\item{verbose}{Deprecated: please use \code{print.level} in \code{nlmPar} argument. Determines the print level of the \code{nlm} optimizer. The default value of 0 means that no
printing occurs, a value of 1 means that the first and last iterations of the optimization are
detailed, and a value of 2 means that each iteration of the optimization is detailed. Ignored unless \code{optMethod="nlm"}.}

\item{nlmPar}{List of parameters to pass to the optimization function \code{\link[stats]{nlm}} (which should be either
\code{print.level}, \code{gradtol}, \code{stepmax}, \code{steptol}, \code{iterlim}, or \code{hessian} -- see \code{nlm}'s documentation
for more detail). Ignored unless \code{optMethod="nlm"}.}

\item{fit}{\code{TRUE} if the HMM should be fitted to the data, \code{FALSE} otherwise. See \code{\link{fitHMM}}. If \code{fit=FALSE} and \code{miData} is a \code{\link{crwData}}
object, then \code{MIfitHMM} returns a list containing a \code{\link{momentuHMMData}} object (if \code{nSims=1}) or, if \code{nSims>1}, a \code{\link{crwSim}} object.}

\item{useInitial}{Logical indicating whether or not to use parameter estimates for the first model fit as initial values for all subsequent model fits.
If \code{ncores>1} then the first model is fit on a single core and then used as the initial values for all subsequent model fits on each core 
(in this case, the progress of the initial model fit can be followed using the \code{verbose} argument). Default: FALSE.}

\item{DM}{An optional named list indicating the design matrices to be used for the probability distribution parameters of each data 
stream. See \code{\link{fitHMM}}.}

\item{cons}{Deprecated: please use \code{workBounds} instead. An optional named list of vectors specifying a power to raise parameters corresponding to each column of the design matrix 
for each data stream. See \code{\link{fitHMM}}.}

\item{userBounds}{An optional named list of 2-column matrices specifying bounds on the natural (i.e, real) scale of the probability 
distribution parameters for each data stream. See \code{\link{fitHMM}}.}

\item{workBounds}{An optional named list of 2-column matrices specifying bounds on the working scale of the probability distribution, transition probability, and initial distribution parameters. See \code{\link{fitHMM}}.}

\item{workcons}{Deprecated: please use \code{workBounds} instead. An optional named list of vectors specifying constants to add to the regression coefficients on the working scale for 
each data stream. See \code{\link{fitHMM}}.}

\item{stateNames}{Optional character vector of length nbStates indicating state names.}

\item{knownStates}{Vector of values of the state process which are known prior to fitting the
model (if any). See \code{\link{fitHMM}}. If \code{miData} is a list of \code{\link{momentuHMMData}} objects, then \code{knownStates} can alternatively
be a list of vectors containing the known values for the state process for each element of \code{miData}.}

\item{fixPar}{An optional list of vectors indicating parameters which are assumed known prior to fitting the model. See \code{\link{fitHMM}}.}

\item{retryFits}{Non-negative integer indicating the number of times to attempt to iteratively fit the model using random perturbations of the current parameter estimates as the 
initial values for likelihood optimization.  See \code{\link{fitHMM}}.}

\item{retrySD}{An optional list of scalars or vectors indicating the standard deviation to use for normal perturbations of each working scale parameter when \code{retryFits>0}. See \code{\link{fitHMM}}.}

\item{optMethod}{The optimization method to be used.  Can be ``nlm'' (the default; see \code{\link[stats]{nlm}}), ``Nelder-Mead'' (see \code{\link[stats]{optim}}), or ``SANN'' (see \code{\link[stats]{optim}}).}

\item{control}{A list of control parameters to be passed to \code{\link[stats]{optim}} (ignored unless \code{optMethod="Nelder-Mead"} or \code{optMethod="SANN"}).}

\item{prior}{A function that returns the log-density of the working scale parameter prior distribution(s).  See \code{\link{fitHMM}}.}

\item{covNames}{Names of any covariates in \code{miData$crwPredict} (if \code{miData} is a \code{\link{crwData}} object; otherwise 
\code{covNames} is ignored). See \code{\link{prepData}}.}

\item{spatialCovs}{List of raster layer(s) for any spatial covariates not included in \code{miData$crwPredict} (if \code{miData} is 
a \code{\link{crwData}} object; otherwise \code{spatialCovs} is ignored). See \code{\link{prepData}}.}

\item{centers}{2-column matrix providing the x-coordinates (column 1) and y-coordinates (column 2) for any activity centers (e.g., potential 
centers of attraction or repulsion) from which distance and angle covariates will be calculated based on realizations of the position process. 
See \code{\link{prepData}}. Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{centroids}{List where each element is a data frame containing the x-coordinates ('x'), y-coordinates ('y'), and times (with user-specified name, e.g., `time') for centroids (i.e., dynamic activity centers where the coordinates can change over time)
from which distance and angle covariates will be calculated based on the location data. See \code{\link{prepData}}. Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{angleCovs}{Character vector indicating the names of any circular-circular regression angular covariates in \code{miData$crwPredict} that need conversion from standard direction (in radians relative to the x-axis) to turning angle (relative to previous movement direction) 
See \code{\link{prepData}}. Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{method}{Method for obtaining weights for movement parameter samples. See \code{\link[crawl]{crwSimulator}}. Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{parIS}{Size of the parameter importance sample. See \code{\link[crawl]{crwSimulator}}. Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{dfSim}{Degrees of freedom for the t approximation to the parameter posterior. See 'df' argument in \code{\link[crawl]{crwSimulator}}. Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{grid.eps}{Grid size for \code{method="quadrature"}. See \code{\link[crawl]{crwSimulator}}. Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{crit}{Criterion for deciding "significance" of quadrature points
(difference in log-likelihood). See \code{\link[crawl]{crwSimulator}}. Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{scaleSim}{Scale multiplier for the covariance matrix of the t approximation. See 'scale' argument in \code{\link[crawl]{crwSimulator}}. 
Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{force.quad}{A logical indicating whether or not to force the execution 
of the quadrature method for large parameter vectors. See \code{\link[crawl]{crwSimulator}}. Default: TRUE. Ignored unless \code{miData} is a \code{\link{crwData}} object and \code{method=``quadrature''}.}

\item{fullPost}{Logical indicating whether to draw parameter values as well to simulate full posterior. See \code{\link[crawl]{crwPostIS}}. Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{dfPostIS}{Degrees of freedom for multivariate t distribution approximation to parameter posterior. See 'df' argument in \code{\link[crawl]{crwPostIS}}. Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{scalePostIS}{Extra scaling factor for t distribution approximation. See 'scale' argument in \code{\link[crawl]{crwPostIS}}. Ignored unless \code{miData} is a \code{\link{crwData}} object.}

\item{thetaSamp}{If multiple parameter samples are available in \code{\link[crawl]{crwSimulator}} objects,
setting \code{thetaSamp=n} will use the nth sample. Defaults to the last. See \code{\link[crawl]{crwSimulator}} and \code{\link[crawl]{crwPostIS}}. 
Ignored unless \code{miData} is a \code{\link{crwData}} object.}
}
\value{
If \code{nSims>1}, \code{poolEstimates=TRUE}, and \code{fit=TRUE}, a \code{\link{miHMM}} object, i.e., a list consisting of:
\item{miSum}{\code{\link{miSum}} object returned by \code{\link{MIpool}}.}
\item{HMMfits}{List of length \code{nSims} comprised of \code{\link{momentuHMM}} objects.}
If \code{poolEstimates=FALSE} and \code{fit=TRUE}, a list of length \code{nSims} consisting of \code{\link{momentuHMM}} objects is returned. 

However, if \code{fit=FALSE} and \code{miData} is a \code{\link{crwData}} 
object, then \code{MIfitHMM} returns a \code{\link{crwSim}} object, i.e., a list containing \code{miData} (a list of 
\code{\link{momentuHMMData}} objects) and \code{crwSimulator} (a list of \code{\link[crawl]{crwSimulator}} objects),and most other arguments related to \code{\link{fitHMM}} are ignored.
}
\description{
Fit a (multivariate) hidden Markov model to multiple imputation data. Multiple imputation is a method for accommodating 
missing data, temporal-irregularity, or location measurement error in hidden Markov models, where pooled parameter estimates reflect uncertainty
attributable to observation error.
}
\details{
\code{miData} can either be a \code{\link{crwData}} object (as returned by \code{\link{crawlWrap}}), a \code{\link{crwSim}} object (as returned by \code{MIfitHMM} when \code{fit=FALSE}), 
or a list of \code{\link{momentuHMMData}} objects (e.g., each element of the list as returned by \code{\link{prepData}}).

If \code{miData} is a \code{crwData} object, \code{MIfitHMM} uses a combination of 
\code{\link[crawl]{crwSimulator}}, \code{\link[crawl]{crwPostIS}}, \code{\link{prepData}}, and \code{\link{fitHMM}} to draw \code{nSims} realizations of the position process
and fit the specified HMM to each imputation of the data. The vast majority of \code{MIfitHMM} arguments are identical to the corresponding arguments from these functions.

If \code{miData} is a \code{\link{crwData}} object, \code{nSims} determines both the number of realizations of the position process to draw 
(using \code{\link[crawl]{crwSimulator}} and \code{\link{crwPostIS}}) as well as the number of HMM fits.

If \code{miData} is a \code{\link{crwSim}} object or a list of \code{\link{momentuHMMData}} object(s), the specified HMM will simply be fitted to each of the \code{momentuHMMData} objects
and all arguments related to \code{\link[crawl]{crwSimulator}}, \code{\link[crawl]{crwPostIS}}, or \code{\link{prepData}} are ignored.
}
\examples{

# Don't run because it takes too long on a single core
\dontrun{
# extract simulated obsData from example data
obsData <- miExample$obsData

# extract crwMLE inputs from example data
inits <- miExample$inits # initial state
err.model <- miExample$err.model # error ellipse model

# create crwData object by fitting crwMLE models to obsData and predict locations 
# at default intervals for both individuals
crwOut <- crawlWrap(obsData=obsData,
         theta=c(4,0),fixPar=c(1,1,NA,NA),
         initial.state=inits,
         err.model=err.model)

# HMM specifications
nbStates <- 2
stepDist <- "gamma"
angleDist <- "vm"
mu0 <- c(20,70)
sigma0 <- c(10,30)
kappa0 <- c(1,1)
stepPar0 <- c(mu0,sigma0)
anglePar0 <- c(-pi/2,pi/2,kappa0)
formula <- ~cov1+cos(cov2)
nbCovs <- 2
beta0 <- matrix(c(rep(-1.5,nbStates*(nbStates-1)),rep(0,nbStates*(nbStates-1)*nbCovs)),
                nrow=nbCovs+1,byrow=TRUE)

# first fit HMM to best predicted position process
bestData<-prepData(crwOut,covNames=c("cov1","cov2"))
bestFit<-fitHMM(bestData,
                nbStates=nbStates,dist=list(step=stepDist,angle=angleDist),
                Par0=list(step=stepPar0,angle=anglePar0),beta0=beta0,
                formula=formula,estAngleMean=list(angle=TRUE))
            
print(bestFit)

# extract estimates from 'bestFit'
bPar0 <- getPar(bestFit)

# Fit nSims=5 imputations of the position process
miFits<-MIfitHMM(miData=crwOut,nSims=5,
                  nbStates=nbStates,dist=list(step=stepDist,angle=angleDist),
                  Par0=bPar0$Par,beta0=bPar0$beta,delta0=bPar0$delta,
                  formula=formula,estAngleMean=list(angle=TRUE),
                  covNames=c("cov1","cov2"))

# print pooled estimates
print(miFits)
}

}
\references{
Hooten M.B., Johnson D.S., McClintock B.T., Morales J.M. 2017. Animal Movement: Statistical Models for Telemetry Data. CRC Press, Boca Raton.

McClintock B.T. 2017. Incorporating telemetry error into hidden Markov movement models using multiple imputation. Journal of Agricultural, Biological,
and Environmental Statistics.
}
\seealso{
\code{\link{crawlWrap}}, \code{\link[crawl]{crwPostIS}}, \code{\link[crawl]{crwSimulator}}, \code{\link{fitHMM}}, \code{\link{getParDM}}, \code{\link{MIpool}}, \code{\link{prepData}}
}
