% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winsimp.R
\name{Winsimp}
\alias{Winsimp}
\title{Winsorization followed by imputation}
\usage{
Winsimp(data, center, scatter, outind, seed = 1000003)
}
\arguments{
\item{data}{a data frame with the data.}

\item{center}{(robust) estimate of the center (location) of the observations.}

\item{scatter}{(robust) estimate of the scatter (covariance-matrix) of the
observations.}

\item{outind}{logical vector indicating outliers with 1 or TRUE for outliers.}

\item{seed}{seed for random number generator.}
}
\value{
\code{Winsimp} returns a list whose first component \code{output} is a
sublist with the following components:
\describe{
  \item{\code{cutpoint}}{Cutpoint for outliers}
  \item{\code{proc.time}}{Processing time}
  \item{\code{n.missing.before}}{Number of missing values before imputation}
  \item{\code{n.missing.after}}{Number of missing values after imputation}
}
The further component returned by \code{winsimp} is:
\describe{
  \item{\code{imputed.data}}{Imputed data set}
}
}
\description{
Winsorization of outliers according to the Mahalanobis distance
followed by an imputation under the multivariate normal model.
Only the outliers are winsorized. The Mahalanobis distance MDmiss
allows for missing values.
}
\details{
It is assumed that \code{center}, \code{scatter} and \code{outind}
stem from a multivariate outlier detection algorithm which produces
robust estimates and which declares outliers observations with a large
Mahalanobis distance. The cutpoint is calculated as the least (unsquared)
Mahalanobis distance among the outliers. The winsorization reduces the
weight of the outliers:
\deqn{\hat{y}_i = \mu_R + (y_i - \mu_R) \cdot c/d_i}
where \eqn{\mu_R} is the robust center and \eqn{d_i} is the (unsquared) Mahalanobis
distance of observation i.
}
\examples{
data(bushfirem, bushfire.weights)
det.res <- TRC(bushfirem, weight = bushfire.weights)
imp.res <- Winsimp(bushfirem, det.res$output$center, det.res$output$scatter, det.res$outind)
print(imp.res$output)
}
\references{
Hulliger, B. (2007), Multivariate Outlier Detection and Treatment
in Business Surveys, Proceedings of the III International Conference on
Establishment Surveys, Montréal.
}
\seealso{
\code{\link{MDmiss}}. Uses \code{\link[norm]{imp.norm}}.
}
\author{
Beat Hulliger
}
