% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pt2.R
\name{Pt2}
\alias{Pt2}
\title{Tool to computate the transition matrix for a Continuous Time Markov Chain, CTMC.}
\usage{
Pt2(R, t, epsilon)
}
\arguments{
\item{R}{numeric, represents the rate matrix of a CTMC. Default value is 0.}

\item{t}{numeric, represents the length of time.}

\item{epsilon}{numeric, represents the error bound of the approximation of P(t). Default values is 0.01.}
}
\description{
\code{Pt2} is used to obtain the transition matrix of a homogeneous continuous time Markov chain for a period of time of t.
}
\examples{
library(modesto)
# A two states CTMC example
Pt2(matrix(c(0,2,3,0),2,2,byrow=TRUE),t=0.7,epsilon=0.005)
# A four states CTMC example
R <- matrix(c(0,2,3,0,4,0,2,0,0,2,0,2,1,0,3,0),4,4,byrow=TRUE)
Pt2(R,t=0.7,epsilon=0.005)
# require(microbenchmark)
# microbenchmark(Pt(R,t=0.7,epsilon=0.005),Pt2(R,t=0.7,epsilon=0.005),times=1000L)
}
\references{
Ross, S, Introduction to Probability Models, Eleven Edition. Academic Press, 2014.

Kulkarni V, Introduction to modeling and analysis of stochastic systems. Second Edition. Springer-Verlag, 2011.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
