% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_functions.R
\name{get_regression_table}
\alias{get_regression_table}
\title{Get regression table}
\usage{
get_regression_table(model, digits = 3, print = FALSE)
}
\arguments{
\item{model}{an \code{lm()} model object}

\item{digits}{number of digits precision in output table}

\item{print}{If TRUE, return in print format suitable for R Markdown}
}
\value{
A tibble-formatted regression table along with lower and upper end 
points of all confidence intervals for all parameters \code{lower_ci} and 
\code{upper_ci}.
}
\description{
Output regression table for an \code{lm()} regression in "tidy" format. This function
is a wrapper function for \code{broom::tidy()} and includes confidence
intervals in the output table by default.
}
\examples{
library(moderndive)

# Fit lm() regression:
mpg_model <- lm(mpg ~ cyl, data = mtcars)

# Get regression table:
get_regression_table(mpg_model)
}
\seealso{
\code{\link[broom]{tidy}}, \code{\link{get_regression_points}}, \code{\link{get_regression_summaries}}
}
