% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moderate.mediation.R
\name{sens.plot}
\alias{sens.plot}
\title{Simulation-Based Sensitivity Analysis Plot for Causal Moderated Mediation Analysis}
\usage{
sens.plot(object, sens.results, effect)
}
\arguments{
\item{object}{Output from the \code{modmed} function.}

\item{sens.results}{An output from the \code{modmed.sens} function.}

\item{effect}{The name of the effect whose sensitivity analysis results are to be plotted (string). effect can be specified as "TIE", "PIE", "PDE", "TDE", "INT", "TIE.ref", "PIE.ref", "PDE.ref", "TDE.ref", "INT.ref", "TIE.dif", "PIE.dif", "PDE.dif", "TDE.dif", or "INT.dif".}
}
\value{
Sensitivity analysis plots for the causal effects in the causal moderated mediation analysis.
}
\description{
Simulation-Based Sensitivity Analysis Plot for Causal Moderated Mediation Analysis
}
\examples{
\donttest{
data(newws)
modmed.results = modmed(data = newws, treatment = "treat", mediator = "emp",
    outcome = "depression", covariates.disc = c("emp_prior", "nevmar",
        "hispanic", "nohsdip"), covariates.cont = c("workpref", "attitude",
        "depress_prior"), moderators.disc = "CHCNT", moderators.cont = "ADCPC",
    m.model = list(intercept = c("ADCPC", "CHCNT"), treatment = c("ADCPC",
        "CHCNT"), emp_prior = NULL, nevmar = NULL, hispanic = NULL,
        nohsdip = NULL, workpref = NULL, attitude = NULL, depress_prior = NULL),
    y.model = list(intercept = c("ADCPC", "CHCNT"), treatment = c("ADCPC",
        "CHCNT"), mediator = c("ADCPC", "CHCNT"), tm = c("ADCPC",
        "CHCNT"), emp_prior = NULL, nevmar = NULL, hispanic = NULL,
        nohsdip = NULL, workpref = NULL, attitude = NULL, depress_prior = NULL),
    comp.mod.disc.values = 3, ref.mod.disc.values = 2, comp.mod.cont.values = 5050,
    ref.mod.cont.values = 5050, m.scale = "binary", y.scale = "continuous",
    seed = 1)
sens.results = modmed.sens(modmed.results, U.scale = "binary", grid.b.m = 2,
    grid.b.y = 2, iter = 2, nsim = 2, ncore = 1)
sens.plot(modmed.results, sens.results, "PIE")
}
}
\references{
Qin, X., & Yang, F. (2020). Simulation-Based Sensitivity Analysis for Causal Mediation Studies.
}
\author{
Xu Qin and Fan Yang
}
