% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{ldexp.modello_number}
\alias{ldexp.modello_number}
\alias{ldexp.default}
\alias{ldexp}
\title{Exponential Distribution: log-density}
\usage{
\method{ldexp}{modello_number}(y, lam)

\method{ldexp}{default}(y, lam)

ldexp(y, lam)
}
\arguments{
\item{y}{observations, numeric or reference object of class 'number'}

\item{lam}{rate parameter, numeric of reference object of class 'number'}
}
\value{
Returns a 'numeric' or a reference object of class 'number'
}
\description{
Considering an Exponential Distribution
calculates the log-density
\deqn{ld = log(\lambda) - \lambda * y; y \ge 0}
}
\examples{
modello.init(10, 10, 10, 10)
## For modello_numbers
y = number(rexp(10))
ld = ldexp(y, .k(1))
print(ld)
print(ld$v)
modello.close()
## For numerics
y = rexp(10)
ld = ldexp(y, 1)
print(ld)
}
\author{
Filippo Monari
}
