% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_binning.R
\name{create_model_matrix}
\alias{create_model_matrix}
\title{Create a usable model matrix from a data frame containing a mix of
continuous and categorical variables}
\usage{
create_model_matrix(dat, id = c(), matrix_out = TRUE, parallel = FALSE)
}
\arguments{
\item{dat}{a tbl}

\item{id}{character, naming the variable in dat which serves as the unique
row identifier. If blank, will be created}

\item{matrix_out}{logical. Should the result be a matrix (\code{TRUE}), suitable
for input into many modelling functions, or should the result be
a tbl (\code{FALSE}), suitible for inspection and further analysis?
Default \code{TRUE}}

\item{parallel}{logical. If \code{TRUE}, parallel
\code{\link[foreach]{foreach}} is used to compute on each
variable. Must register a parallel backend first. Default
\code{FALSE}.}
}
\value{
a matrix or a tbl, consisting of dummy columns with 0/1 indicators
        of membership in each factor level for each factor variable, and all
        other input variables unchanged.
}
\description{
This function takes your dataframe of input variables and returns a new
dataframe (or matrix) with the categorical variables replaced by dummy
variables, using \code{\link[stats]{model.matrix}}
}
\details{
The function will only alter variables which are type \code{factor}. Contrary
to how it may sound, this actually offers the user greater flexibility, for
two reasons: it allows you to keep character type variables intact, and it
forces you to think about the levels of each factor variable rather than
picking them straight from the input data
}
\examples{
x <- simple_bin(iris,bins = 3)
create_model_matrix(x)
create_model_matrix(x,matrix_out = FALSE)

}

