% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-pmtree.R
\name{coxph_plot}
\alias{coxph_plot}
\title{Survival plot for a given coxph model
with one binary covariate.}
\usage{
coxph_plot(mod, data = NULL, theme = theme_classic(), yrange = NULL)
}
\arguments{
\item{mod}{A model of class coxph.}

\item{data}{optional data frame. If NULL the data stored in mod is used.}

\item{theme}{A ggplot2 theme.}

\item{yrange}{Range of the y variable to be used for plotting.
If NULL it will be 0 to max(y).}
}
\description{
Can be used on its own but is also useable as plotfun in
\code{\link{node_pmterminal}}.
}
\examples{
if(require("survival")) {
  coxph_plot(coxph(Surv(futime, fustat) ~ factor(rx), ovarian))
}

}
