% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr_data.R
\name{inv_comm}
\alias{inv_comm}
\alias{inv_plot_attr}
\title{Invasive plants dataset}
\description{
Herbaceous plant species counts sites invaded and uninvaded by
  \emph{Lonicera maackii} (Amur honeysuckle) which is an invasive shrub.
}
\details{
\code{inv_comm} is a site-by-species matrix with individual counts.

  \code{inv_plot_attr} is a data frame with corresponding site variables. The
  column \code{group} specifies whether a site is "invaded" or "uninvaded".
  This variable is considered a "treatment" in the mob framework. The columns
  \code{x} and \code{y} contain the spatial coordinates of the sites.

  The data were adapted from Powell et al (2013).
}
\examples{
data(inv_comm)
data(inv_plot_attr)
inv_mob_in = make_mob_in(inv_comm, inv_plot_attr)
}
\references{
Powell, K. I., Chase, J. M., & Knight, T. M. (2013). Invasive
  plants have scale-dependent effects on diversity by altering species-area
  relationships. Science, 339: 316-318.
}
\keyword{data}
\keyword{invaded}
\keyword{invasion}
