% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/level_curves.R
\name{curve.funct.a}
\alias{curve.funct.a}
\title{Create level curves for copulae and other models}
\usage{
curve.funct.a(
  px,
  py,
  mar1,
  mar2,
  pos,
  pobje,
  ng = 100,
  inter = "comb",
  logm = FALSE,
  coco,
  c1
)
}
\arguments{
\item{px}{Uniform values of the first margin with a mixed distribution (empirical below and gpd above a threshold)}

\item{py}{Uniform values of the second margin with a mixed distribution (empirical below and gpd above a threshold)}

\item{mar1}{Values of the first margin}

\item{mar2}{Values of the second margin}

\item{pos}{part of the curve to be modelled '\code{l}' for the left part, '\code{m}' for the moddle part and '\code{r}' for the right part}

\item{pobje}{probability of the level curve to be modelled}

\item{ng}{number of points to be interpolated}

\item{inter}{type of hazard interrelation '\code{comb}' for compound and '\code{casc}' for cascade,}

\item{logm}{log tranformation of the margins '\code{T}'of '\code{F}'}

\item{coco}{a copula function from the following: GHcop,NORMcop,FGMcop,GLcop}

\item{c1}{the parameter of the copula}
}
\value{
Level curves for a given joint probability
}
\description{
Take data on uniform margins and fit the Ledford and Tawn (1997) joint tail model. Also contains the method where additional information from values that are extreme in at most one variable is used.
}
