#' mnis_department
#'
#' @param departmentId The department look up. 0 returns the cabinet/shadow cabinet, -1 returns a list of all ministers/
#' @param bench Flag to return either Government or Opposition information. Defaults to Government.
#' @param former Flag to include both current and former ministers/shadow ministers. Defaults to TRUE.
#' @param tidy Fix the variable names in the data frame to remove '@' characters and superfluous text. Defaults to TRUE.
#' @return A list with information on the outcome of the most recent election in a constituency
#' @keywords mnis
#' @export
#' @examples \dontrun{
#' x <- mnis_department(departmentId = 0, bench = 'Government', former=TRUE)
#'
#' }
#'


mnis_department <- function(departmentId = 0, bench = "Government", former = TRUE, tidy = TRUE) {

    if (former == TRUE) {

        former <- "former"

    } else {

        former <- "current"
    }

    departmentId <- as.character(departmentId)

    bench <- utils::URLencode(bench)

    baseurl <- "http://data.parliament.uk/membersdataplatform/services/mnis/Department/"

    query <- paste0(baseurl, departmentId, "/", bench, "/", former, "/")

    got <- httr::GET(query, httr::accept_json())

    if (httr::http_status(got) != "200"){
      stop(print(httr::http_status(got)), call. = FALSE)
    }

    if (httr::http_type(got) != "application/json") {
        stop("API did not return json", call. = FALSE)
    }

    got <- jsonlite::fromJSON(httr::content(got, "text"), flatten = TRUE)

    x <- got$Department$Posts

    x <- as.data.frame(x)

    if (tidy == TRUE) {

        # names(x) <- gsub('Post.PostHolders.', '', names(x))

        # names(x) <- sub('PostHolder.Member.', '', names(x))

        # names(x) <- sub('..xsi.nil', '', names(x))

        # names(x) <- sub('..xmlns.xsi', '', names(x))

        # names(x) <- sub('\'.Member_Id\'', 'Member_Id', names(x))

        # names(x) <- sub('\'.Dods_Id\'', 'Dods_Id', names(x))

        # names(x) <- sub('\'.Pims_Id\'', 'Pims_Id', names(x))

        x <- mnis_tidy(x)

        x

    } else {

        x

    }

}

mnis_Department <- function(departmentId = 0, bench = "Government", former = TRUE) {
    .Deprecated("mnis_Department")
    mnis_department(departmentId = departmentId, bench = bench, former = former)
}
