% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmir_model.R
\name{mmir_model}
\alias{mmir_model}
\title{Fit Restriktor Supported Model}
\usage{
mmir_model(formula, data, engine = "lm", standardize = TRUE, ...)
}
\arguments{
\item{formula}{An object of class 'formula' (or one that can be coerced to
that class): a symbolic description of the model to be fitted.}

\item{data}{A data frame containing the variables in the model.}

\item{engine}{A character string indicating which engine to use for model
fitting. Can be one of 'lm', 'glm', or 'rlm'. Default is 'lm'.}

\item{standardize}{Logical. If TRUE, numeric predictor variables in 'data' are
standardized before fitting the model. Default is TRUE.}

\item{...}{Additional arguments to be passed to the model fitting function
(lm, glm, or rlm).}
}
\value{
An object representing the fitted model, of class 'lm', 'glm', or 'rlm'
depending on the engine used.
}
\description{
mmir_model() is a function for the 'mmirestriktor' package that fits
a model to data using one of the specified engines ('lm', 'glm', or 'rlm').
It also provides an option to standardize numeric variables.
}
\details{
The mmir_model() function serves as a utility function for fitting models
in the 'mmirestriktor' package. It supports different modeling engines and
allows for variable standardization.
}
\examples{
mod <- mmir_model(mpg ~ hp + wt, data = mtcars, engine = "lm")
summary(mod)

}
\seealso{
\code{\link[stats]{lm}}, \code{\link[stats]{glm}}, \code{\link[MASS]{rlm}}
}
