% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/kmplotmlx.R
\name{kmplotmlx}
\alias{kmplotmlx}
\title{Kaplan Meier plot}
\usage{
kmplotmlx(r, index = 1, level = NULL)
}
\arguments{
\item{r}{a data frame with a column \samp{id}, a column \samp{time},
a column with values and possibly a column \samp{group}.}

\item{index}{an integer: \code{index=k} means that the survival function for the k-th event is displayed.
Default is \code{index=1}.}

\item{level}{a number between 0 and 1:  confidence interval level.}
}
\description{
Plot empirical survival functions using the Kaplan Meier estimate.
}
\details{
See http://simulx.webpopix.org/mlxr/kmplotmlx/ for more details.
}
\examples{
\dontrun{
tteModel1 <- inlineModel("
  [LONGITUDINAL]
  input = {beta,lambda}
  EQUATION:
  h=(beta/lambda)*(t/lambda)^(beta-1)
  DEFINITION:
  e = {type=event, maxEventNumber=1, rightCensoringTime=70, hazard=h}
  ")

  p1   <- c(beta=2.5,lambda=50)
  e    <- list(name='e', time=0)
  res1 <- simulx(model=tteModel1, parameter=p1, output=e, group=list(size=100))
  pl1  <- kmplotmlx(res1$e,level=0.95)
  print(pl1)

  p2   <- c(beta=2,lambda=45)
  g1   <- list(size=50, parameter=p1)
  g2   <- list(size=100, parameter=p2)
  res2 <- simulx(model=tteModel1, output=e, group=list(g1,g2))
  pl2  <- kmplotmlx(res2$e)
  print(pl2)
}
}

