% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{loc_constant}
\alias{loc_constant}
\title{Nonparametric smoothing}
\usage{
loc_constant(bw, x, y, db_kernel = 0L)
}
\arguments{
\item{bw, }{double, bandwidth, between 0 and 1.}

\item{x, }{vector, covariates}

\item{y, }{matrix, response variables}

\item{db_kernel, }{bool, whether to use jackknife kernel, default 0}
}
\value{
a matrix of smoothed values
}
\description{
Nonparametric smoothing
}
\examples{
n <- 800
p <- 3
t <- (1:n)/n
V <-  matrix(rnorm(n * p), nrow = p)
V3 <- loc_constant(0.2, t, V,1)
}
