% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infill_crits.R
\name{infillcrits}
\alias{infillcrits}
\alias{makeMBOInfillCritMeanResponse}
\alias{makeMBOInfillCritStandardError}
\alias{makeMBOInfillCritEI}
\alias{makeMBOInfillCritCB}
\alias{makeMBOInfillCritAEI}
\alias{makeMBOInfillCritEQI}
\alias{makeMBOInfillCritDIB}
\alias{makeMBOInfillCritAdaCB}
\title{Infill criteria.}
\usage{
makeMBOInfillCritMeanResponse()

makeMBOInfillCritStandardError()

makeMBOInfillCritEI(se.threshold = 1e-06)

makeMBOInfillCritCB(cb.lambda = NULL)

makeMBOInfillCritAEI(aei.use.nugget = FALSE, se.threshold = 1e-06)

makeMBOInfillCritEQI(eqi.beta = 0.75, se.threshold = 1e-06)

makeMBOInfillCritDIB(cb.lambda = 1, sms.eps = NULL)

makeMBOInfillCritAdaCB(cb.lambda.start = NULL, cb.lambda.end = NULL)
}
\arguments{
\item{se.threshold}{[\code{numeric(1)}]\cr
In order to avoid numerical problems the standard error estimation is assumed to
be exactly zero, if it is below \code{se.threshold}.
Default is 1e-6.}

\item{cb.lambda}{[\code{numeric(1)} | \code{NULL}]\cr
Lambda parameter for confidence bound infill criterion.
Default is \code{NULL}, which means 1 in case of a fully numeric parameter set and 2 otherwise.}

\item{aei.use.nugget}{[\code{logical(1)}]\cr
Should the nugget effect be used for the pure variance estimation for augmented
expected improvement?
Default is \code{FALSE}.}

\item{eqi.beta}{[\code{numeric(1)}]\cr
Beta parameter for expected quantile improvement criterion.
Default is 0.75.}

\item{sms.eps}{[\code{numeric(1)} | \code{NULL}]\cr
Epsilon for epsilon-dominance for \code{dib.indicator = "sms"}.
Default is \code{NULL}, in this case it is adaptively set.}

\item{cb.lambda.start}{[\code{numeric(1)} | \code{NULL}]\cr
The value of \code{cb.lambda} at the beginning of the optimization.
The \code{makeMBOInfillCritAdaCB} crit takes the progress of the optimization determined by the termination criterion to linearly move from \code{cb.lambda.start} to \code{cb.lambda.end}.
The initial desgin does not account for the progress of the optimization.
Eexcept for \code{makeMBOTerminationMaxExecBudget}) if you dont pass a precalculated initial design.}

\item{cb.lambda.end}{[\code{numeric(1)} | \code{NULL}]\cr
The value of \code{cb.lambda} at the end of the optimization.}
}
\description{
\pkg{mlrMBO} contains most of the most popular infill criteria, e.g., expected
improvement, (lower) confidence bound etc. Moreover, custom infill criteria
may be generated with the \code{\link{makeMBOInfillCrit}} function.
}
\details{
In the multi-objective case we recommend to set \code{cb.lambda} to
\eqn{q(0.5 \cdot \pi_{CB}^{(1 / n)})} where \eqn{q} is the quantile
function of the standard normal distribution, \eqn{\pi_CB} is the probability
of improvement value and \eqn{n} is the number of objectives of the considered problem.
}
\seealso{
\code{\link{makeMBOInfillCrit}}
}
