% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackBatchTuning.R
\name{callback_batch_tuning}
\alias{callback_batch_tuning}
\title{Create Batch Tuning Callback}
\usage{
callback_batch_tuning(
  id,
  label = NA_character_,
  man = NA_character_,
  on_optimization_begin = NULL,
  on_optimizer_before_eval = NULL,
  on_eval_after_design = NULL,
  on_eval_after_benchmark = NULL,
  on_eval_before_archive = NULL,
  on_optimizer_after_eval = NULL,
  on_tuning_result_begin = NULL,
  on_result_begin = NULL,
  on_result_end = NULL,
  on_result = NULL,
  on_optimization_end = NULL
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{label}{(\code{character(1)})\cr
Label for the new instance.}

\item{man}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}

\item{on_optimization_begin}{(\verb{function()})\cr
Stage called at the beginning of the optimization.
Called in \code{Optimizer$optimize()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_optimizer_before_eval}{(\verb{function()})\cr
Stage called after the optimizer proposes points.
Called in \code{OptimInstance$eval_batch()}.
The functions must have two arguments named \code{callback} and \code{context}.
The argument of \verb{$eval_batch(xdt)} is available in \code{context}.}

\item{on_eval_after_design}{(\verb{function()})\cr
Stage called after the design is created.
Called in \code{ObjectiveTuningBatch$eval_many()}.
The functions must have two arguments named \code{callback} and \code{context}.
The arguments of \verb{$eval_many(xss, resampling)} are available in \code{context}.
Additionally, the \code{design} is available in \code{context}.}

\item{on_eval_after_benchmark}{(\verb{function()})\cr
Stage called after hyperparameter configurations are evaluated.
Called in \code{ObjectiveTuningBatch$eval_many()}.
The functions must have two arguments named \code{callback} and \code{context}.
The \code{benchmark_result} is available in \code{context}.}

\item{on_eval_before_archive}{(\verb{function()})\cr
Stage called before performance values are written to the archive.
Called in \code{ObjectiveTuningBatch$eval_many()}.
The functions must have two arguments named \code{callback} and \code{context}.
The \code{aggregated_performance} is available in \code{context}.}

\item{on_optimizer_after_eval}{(\verb{function()})\cr
Stage called after points are evaluated.
Called in \code{OptimInstance$eval_batch()}.
The functions must have two arguments named \code{callback} and \code{context}.
The new configurations and performances in \code{instance$archive} are available in \code{context}.}

\item{on_tuning_result_begin}{(\verb{function()})\cr
Stage called at the beginning of the result writing.
Called in \code{TuningInstanceBatch$assign_result()}.
The functions must have two arguments named \code{callback} and \code{context}.
The arguments of \verb{$assign_result(xdt, y, learner_param_vals, extra)} are available in \code{context}.}

\item{on_result_begin}{(\verb{function()})\cr
Stage called at the beginning of the result writing.
Called in \code{OptimInstance$assign_result()}.
The functions must have two arguments named \code{callback} and \code{context}.
The arguments of \verb{$assign_result(xdt, y, extra)} are available in \code{context}.}

\item{on_result_end}{(\verb{function()})\cr
Stage called after the result is written.
Called in \code{OptimInstance$assign_result()}.
The functions must have two arguments named \code{callback} and \code{context}.
The final result \code{instance$result} is available in \code{context}.}

\item{on_result}{(\verb{function()})\cr
Deprecated.
Use \code{on_result_end} instead.
Stage called after the result is written.
Called in \code{OptimInstance$assign_result()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_optimization_end}{(\verb{function()})\cr
Stage called at the end of the optimization.
Called in \code{Optimizer$optimize()}.
The functions must have two arguments named \code{callback} and \code{context}.}
}
\description{
Function to create a \link{CallbackBatchTuning}.
Predefined callbacks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_callbacks} and can be retrieved with \code{\link[=clbk]{clbk()}}.

Tuning callbacks can be called from different stages of the tuning process.
The stages are prefixed with \verb{on_*}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Start Tuning
     - on_optimization_begin
    Start Tuner Batch
         - on_optimizer_before_eval
        Start Evaluation
             - on_eval_after_design
             - on_eval_after_benchmark
             - on_eval_before_archive
        End Evaluation
         - on_optimizer_after_eval
    End Tuner Batch
     - on_tuning_result_begin
     - on_result_begin
     - on_result_end
     - on_optimization_end
End Tuning
}\if{html}{\out{</div>}}

See also the section on parameters for more information on the stages.
A tuning callback works with \link{ContextBatchTuning}.
}
\details{
When implementing a callback, each function must have two arguments named \code{callback} and \code{context}.
A callback can write data to the state (\verb{$state}), e.g. settings that affect the callback itself.
Tuning callbacks access \link{ContextBatchTuning}.
}
\examples{
# write archive to disk
callback_batch_tuning("mlr3tuning.backup",
  on_optimization_end = function(callback, context) {
    saveRDS(context$instance$archive, "archive.rds")
  }
)
}
