% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoTuner.R
\name{AutoTuner}
\alias{AutoTuner}
\title{AutoTuner}
\description{
The \code{AutoTuner} is a \link[mlr3:Learner]{mlr3::Learner} which wraps another \link[mlr3:Learner]{mlr3::Learner}
and performs the following steps during \verb{$train()}:
\enumerate{
\item The hyperparameters of the wrapped (inner) learner are trained on the
training data via resampling.
The tuning can be specified by providing a \link{Tuner}, a \link[bbotk:Terminator]{bbotk::Terminator},
a search space as \link[paradox:ParamSet]{paradox::ParamSet}, a \link[mlr3:Resampling]{mlr3::Resampling} and a
\link[mlr3:Measure]{mlr3::Measure}.
\item The best found hyperparameter configuration is set as hyperparameters
for the wrapped (inner) learner stored in \code{at$learner}. Access the tuned
hyperparameters via \code{at$learner$param_set$values}.
\item A final model is fit on the complete training data using the now
parametrized wrapped learner. The respective model is available via field
\code{at$learner$model}.
}

During \verb{$predict()} the \code{AutoTuner} just calls the predict method of the
wrapped (inner) learner. A set timeout is disabled while fitting the final
model.

Note that this approach allows to perform nested resampling by passing an
\link{AutoTuner} object to \code{\link[mlr3:resample]{mlr3::resample()}} or \code{\link[mlr3:benchmark]{mlr3::benchmark()}}.
To access the inner resampling results, set \code{store_tuning_instance = TRUE}
and execute \code{\link[mlr3:resample]{mlr3::resample()}} or \code{\link[mlr3:benchmark]{mlr3::benchmark()}} with
\code{store_models = TRUE} (see examples).
}
\examples{
task = tsk("pima")
train_set = sample(task$nrow, 0.8 * task$nrow)
test_set = setdiff(seq_len(task$nrow), train_set)

at = AutoTuner$new(
  learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE)),
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  terminator = trm("evals", n_evals = 5),
  tuner = tnr("random_search"))

# tune hyperparameters and fit final model
at$train(task, row_ids = train_set)

# predict with final model
at$predict(task, row_ids = test_set)

# show tuning result
at$tuning_result

# model slot contains trained learner and tuning instance
at$model

# shortcut trained learner
at$learner

# shortcut tuning instance
at$tuning_instance


### nested resampling

at = AutoTuner$new(
  learner = lrn("classif.rpart", cp = to_tune(1e-04, 1e-1, logscale = TRUE)),
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  terminator = trm("evals", n_evals = 5),
  tuner = tnr("random_search"))

resampling_outer = rsmp("cv", folds = 3)
rr = resample(task, at, resampling_outer, store_models = TRUE)

# retrieve inner tuning results.
extract_inner_tuning_results(rr)

# performance scores estimated on the outer resampling
rr$score()

# unbiased performance of the final model trained on the full data set
rr$aggregate()
}
\section{Super class}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{AutoTuner}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{instance_args}}{(\code{list()})\cr
All arguments from construction to create the \link{TuningInstanceSingleCrit}.}

\item{\code{tuner}}{(\link{Tuner}).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{archive}}{\link{ArchiveTuning}\cr
Archive of the \link{TuningInstanceSingleCrit}.}

\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Trained learner}

\item{\code{tuning_instance}}{(\link{TuningInstanceSingleCrit})\cr
Internally created tuning instance with all intermediate results.}

\item{\code{tuning_result}}{(\link[data.table:data.table]{data.table::data.table})\cr
Short-cut to \code{result} from \link{TuningInstanceSingleCrit}.}

\item{\code{predict_type}}{(\code{character(1)})\cr
Stores the currently active predict type, e.g. \code{"response"}.
Must be an element of \verb{$predict_types}.}

\item{\code{hash}}{(\code{character(1)})\cr
Hash (unique identifier) for this object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AutoTuner-new}{\code{AutoTuner$new()}}
\item \href{#method-AutoTuner-base_learner}{\code{AutoTuner$base_learner()}}
\item \href{#method-AutoTuner-print}{\code{AutoTuner$print()}}
\item \href{#method-AutoTuner-clone}{\code{AutoTuner$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutoTuner-new"></a>}}
\if{latex}{\out{\hypertarget{method-AutoTuner-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutoTuner$new(
  learner,
  resampling,
  measure = NULL,
  terminator,
  tuner,
  search_space = NULL,
  store_tuning_instance = TRUE,
  store_benchmark_result = TRUE,
  store_models = FALSE,
  check_values = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Learner to tune, see \link{TuningInstanceSingleCrit}.}

\item{\code{resampling}}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Resampling strategy during tuning, see \link{TuningInstanceSingleCrit}. This
\link[mlr3:Resampling]{mlr3::Resampling} is meant to be the \strong{inner} resampling, operating
on the training set of an arbitrary outer resampling. For this reason
it is not feasible to pass an instantiated \link[mlr3:Resampling]{mlr3::Resampling} here.}

\item{\code{measure}}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Performance measure to optimize.}

\item{\code{terminator}}{(\link[bbotk:Terminator]{bbotk::Terminator})\cr
When to stop tuning, see \link{TuningInstanceSingleCrit}.}

\item{\code{tuner}}{(\link{Tuner})\cr
Tuning algorithm to run.}

\item{\code{search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Hyperparameter search space. If \code{NULL}, the search space is constructed
from the \link{TuneToken} in the \code{ParamSet} of the learner.}

\item{\code{store_tuning_instance}}{(\code{logical(1)})\cr
If \code{TRUE} (default), stores the internally created
\link{TuningInstanceSingleCrit} with all intermediate results in slot
\verb{$tuning_instance}.}

\item{\code{store_benchmark_result}}{(\code{logical(1)})\cr
If \code{TRUE} (default), store resample result of evaluated hyperparameter
configurations in archive as \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}.}

\item{\code{store_models}}{(\code{logical(1)})\cr
If \code{TRUE}, fitted models are stored in the benchmark result
(\code{archive$benchmark_result}). If \code{store_benchmark_result = FALSE}, models
are only stored temporarily and not accessible after the tuning. This
combination is needed for measures that require a model.}

\item{\code{check_values}}{(\code{logical(1)})\cr
If \code{TRUE}, hyperparameter values are checked before evaluation and
performance scores after. If \code{FALSE} (default), values are unchecked but
computational overhead is reduced.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutoTuner-base_learner"></a>}}
\if{latex}{\out{\hypertarget{method-AutoTuner-base_learner}{}}}
\subsection{Method \code{base_learner()}}{
Extracts the base learner from nested learner objects like
\code{GraphLearner} in \CRANpkg{mlr3pipelines}. If \code{recursive = 0}, the (tuned)
learner is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutoTuner$base_learner(recursive = Inf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{recursive}}{(\code{integer(1)})\cr
Depth of recursion for multiple nested objects.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Learner}.
Printer.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutoTuner-print"></a>}}
\if{latex}{\out{\hypertarget{method-AutoTuner-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutoTuner$print()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AutoTuner-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AutoTuner-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AutoTuner$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
