% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerTorch.R
\name{mlr_learners_torch}
\alias{mlr_learners_torch}
\alias{LearnerTorch}
\title{Base Class for Torch Learners}
\description{
This base class provides the basic functionality for training and prediction of a neural network.
All torch learners should inherit from this class.
}
\section{Validation}{

To specify the validation data, you can set the \verb{$validate} field of the Learner, which can be set to:
\itemize{
\item \code{NULL}: no validation
\item \code{ratio}: only proportion \code{1 - ratio} of the task is used for training and \code{ratio} is used for validation.
\item \code{"test"} means that the \code{"test"} task of a resampling is used and is not possible when calling \verb{$train()} manually.
\item \code{"predefined"}: This will use the predefined \verb{$internal_valid_task} of a \code{\link[mlr3:Task]{mlr3::Task}}.
}

This validation data can also be used for early stopping, see the description of the \code{Learner}'s parameters.
}

\section{Saving a Learner}{

In order to save a \code{LearnerTorch} for later usage, it is necessary to call the \verb{$marshal()} method on the \code{Learner}
before writing it to disk, as the object will otherwise not be saved correctly.
After loading a marshaled \code{LearnerTorch} into R again, you then need to call \verb{$unmarshal()} to transform it
into a useable state.
}

\section{Early Stopping and Internal Tuning}{

In order to prevent overfitting, the \code{LearnerTorch} class allows to use early stopping via the \code{patience}
and \code{min_delta} parameters, see the \code{Learner}'s parameters.
When tuning a \code{LearnerTorch} it is also possible to combine the explicit tuning via \code{mlr3tuning}
and the \code{LearnerTorch}'s internal tuning of the epochs via early stopping.
To do so, you just need to include \verb{epochs = to_tune(upper = <upper>, internal = TRUE)} in the search space,
where \verb{<upper>} is the maximally allowed number of epochs, and configure the early stopping.
}

\section{Model}{

The Model is a list of class \code{"learner_torch_model"} with the following elements:
\itemize{
\item \code{network} :: The trained \link[torch:nn_module]{network}.
\item \code{optimizer} :: The \verb{$state_dict()} \link[torch:optimizer]{optimizer} used to train the network.
\item \code{loss_fn} :: The \verb{$state_dict()} of the \link[torch:nn_module]{loss} used to train the network.
\item \code{callbacks} :: The \link[=mlr_callback_set]{callbacks} used to train the network.
\item \code{seed} :: The seed that was / is used for training and prediction.
\item \code{epochs} :: How many epochs the model was trained for (early stopping).
\item \code{task_col_info} :: A \code{data.table()} containing information about the train-task.
}
}

\section{Parameters}{


\strong{General}:

The parameters of the optimizer, loss and callbacks,
prefixed with \code{"opt."}, \code{"loss."} and \code{"cb.<callback id>."} respectively, as well as:
\itemize{
\item \code{epochs} :: \code{integer(1)}\cr
The number of epochs.
\item \code{device} :: \code{character(1)}\cr
The device. One of \code{"auto"}, \code{"cpu"}, or \code{"cuda"} or other values defined in \code{mlr_reflections$torch$devices}.
The value is initialized to \code{"auto"}, which will select \code{"cuda"} if possible, then try \code{"mps"} and otherwise
fall back to \code{"cpu"}.
\item \code{num_threads} :: \code{integer(1)}\cr
The number of threads for intraop pararallelization (if \code{device} is \code{"cpu"}).
This value is initialized to 1.
\item \code{num_interop_threads} :: \code{integer(1)}\cr
The number of threads for intraop and interop pararallelization (if \code{device} is \code{"cpu"}).
This value is initialized to 1.
Note that this can only be set once during a session and changing the value within an R session will raise a warning.
\item \code{seed} :: \code{integer(1)} or \code{"random"} or \code{NULL}\cr
The torch seed that is used during training and prediction.
This value is initialized to \code{"random"}, which means that a random seed will be sampled at the beginning of the
training phase. This seed (either set or randomly sampled) is available via \verb{$model$seed} after training
and used during prediction.
Note that by setting the seed during the training phase this will mean that by default (i.e. when \code{seed} is
\code{"random"}), clones of the learner will use a different seed.
If set to \code{NULL}, no seeding will be done.
\item \code{tensor_dataset} :: \code{logical(1)} | \code{"device"}\cr
Whether to load all batches at once at the beginning of training and stack them.
This is initialized to \code{FALSE}.
If set to \code{"device"}, the device of the tensors will be set to the value of \code{device}, which
can avoid unnecessary moving of tensors between devices.
When your dataset fits into memory this will make the loading of batches faster.
Note that this should not be set for datasets that contain \code{\link{lazy_tensor}}s with random data augmentation,
as this augmentation will only be applied once at the beginning of training.
}

\strong{Evaluation}:
\itemize{
\item \code{measures_train} :: \code{\link[mlr3:Measure]{Measure}} or \code{list()} of \code{\link[mlr3:Measure]{Measure}}s\cr
Measures to be evaluated during training.
\item \code{measures_valid} :: \code{\link[mlr3:Measure]{Measure}} or \code{list()} of \code{\link[mlr3:Measure]{Measure}}s\cr
Measures to be evaluated during validation.
\item \code{eval_freq} :: \code{integer(1)}\cr
How often the train / validation predictions are evaluated using \code{measures_train} / \code{measures_valid}.
This is initialized to \code{1}.
Note that the final model is always evaluated.
}

\strong{Early Stopping}:
\itemize{
\item \code{patience} :: \code{integer(1)}\cr
This activates early stopping using the validation scores.
If the performance of a model does not improve for \code{patience} evaluation steps, training is ended.
Note that the final model is stored in the learner, not the best model.
This is initialized to \code{0}, which means no early stopping.
The first entry from \code{measures_valid} is used as the metric.
This also requires to specify the \verb{$validate} field of the Learner, as well as \code{measures_valid}.
If this is set, the epoch after which no improvement was observed, can be accessed via the \verb{$internal_tuned_values}
field of the learner.
\item \code{min_delta} :: \code{double(1)}\cr
The minimum improvement threshold for early stopping.
Is initialized to 0.
}

\strong{Dataloader}:
\itemize{
\item \code{batch_size} :: \code{integer(1)}\cr
The batch size (required).
\item \code{shuffle} :: \code{logical(1)}\cr
Whether to shuffle the instances in the dataset. This is initialized to \code{TRUE},
which differs from the default (\code{FALSE}).
\item \code{sampler} :: \code{\link[torch:sampler]{torch::sampler}}\cr
Object that defines how the dataloader draw samples.
\item \code{batch_sampler} :: \code{\link[torch:sampler]{torch::sampler}}\cr
Object that defines how the dataloader draws batches.
\item \code{num_workers} :: \code{integer(1)}\cr
The number of workers for data loading (batches are loaded in parallel).
The default is \code{0}, which means that data will be loaded in the main process.
\item \code{collate_fn} :: \code{function}\cr
How to merge a list of samples to form a batch.
\item \code{pin_memory} :: \code{logical(1)}\cr
Whether the dataloader copies tensors into CUDA pinned memory before returning them.
\item \code{drop_last} :: \code{logical(1)}\cr
Whether to drop the last training batch in each epoch during training. Default is \code{FALSE}.
\item \code{timeout} :: \code{numeric(1)}\cr
The timeout value for collecting a batch from workers.
Negative values mean no timeout and the default is \code{-1}.
\item \code{worker_init_fn} :: \verb{function(id)}\cr
A function that receives the worker id (in \verb{[1, num_workers]}) and is exectued after seeding
on the worker but before data loading.
\item \code{worker_globals} :: \code{list()} | \code{character()}\cr
When loading data in parallel, this allows to export globals to the workers.
If this is a character vector, the objects in the global environment with those names
are copied to the workers.
\item \code{worker_packages} :: \code{character()}\cr
Which packages to load on the workers.
}

Also see \code{torch::dataloder} for more information.
}

\section{Inheriting}{

There are no seperate classes for classification and regression to inherit from.
Instead, the \code{task_type} must be specified  as a construction argument.
Currently, only classification and regression are supported.

When inheriting from this class, one should overload two private methods:
\itemize{
\item \code{.network(task, param_vals)}\cr
(\code{\link[mlr3:Task]{Task}}, \code{list()}) -> \code{\link[torch:nn_module]{nn_module}}\cr
Construct a \code{\link[torch:nn_module]{torch::nn_module}} object for the given task and parameter values, i.e. the neural network that
is trained by the learner.
For classification, the output of this network are expected to be the scores before the application of the
final softmax layer.
\item \code{.dataset(task, param_vals)}\cr
(\code{\link[mlr3:Task]{Task}}, \code{list()}) -> \code{\link[torch:dataset]{torch::dataset}}\cr
Create the dataset for the task.
The dataset must return a named list where:
\itemize{
\item \code{x} is a list of torch tensors that are the input to the network.
For networks with more than one input, the names must correspond to the inputs of the network.
\item \code{y} is the target tensor.
\item \code{.index} are the indices of the batch (\code{integer()} or a \code{torch_int()}).
}

Moreover, one needs to pay attention respect the row ids of the provided task.
}

It is also possible to overwrite the private \code{.dataloader()} method.
This must respect the dataloader parameters from the \code{\link[paradox:ParamSet]{ParamSet}}.
\itemize{
\item \code{.dataloader(dataset, param_vals)}\cr
(\code{\link[mlr3:Task]{Task}}, \code{list()}) -> \code{\link[torch:dataloader]{torch::dataloader}}\cr
Create a dataloader from the task.
Needs to respect at least \code{batch_size} and \code{shuffle} (otherwise predictions can be permuted).
}

To change the predict types, the it is possible to overwrite the method below:
\itemize{
\item \code{.encode_prediction(predict_tensor, task)}\cr
(\code{\link[torch:torch_tensor]{torch_tensor}}, \code{\link[mlr3:Task]{Task}}) -> \code{list()}\cr
Take in the raw predictions from \code{self$network} (\code{predict_tensor}) and encode them into a
format that can be converted to valid \code{mlr3} predictions using \code{\link[mlr3:as_prediction_data]{mlr3::as_prediction_data()}}.
This method must take \code{self$predict_type} into account.
}

While it is possible to add parameters by specifying the \code{param_set} construction argument, it is currently
not possible to remove existing parameters, i.e. those listed in section \emph{Parameters}.
None of the parameters provided in \code{param_set} can have an id that starts with \code{"loss."}, \verb{"opt.", or }"cb."`, as these are preserved for the dynamically constructed parameters of the optimizer, the loss function,
and the callbacks.

To perform additional input checks on the task, the private \code{.verify_train_task(task, param_vals)} and
\code{.verify_predict_task(task, param_vals)} can be overwritten.

For learners that have other construction arguments that should change the hash of a learner, it is required
to implement the private \verb{$.additional_phash_input()}.
}

\seealso{
Other Learner: 
\code{\link{mlr_learners.mlp}},
\code{\link{mlr_learners.tab_resnet}},
\code{\link{mlr_learners.torch_featureless}},
\code{\link{mlr_learners_torch_image}},
\code{\link{mlr_learners_torch_model}}
}
\concept{Learner}
\section{Super class}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{LearnerTorch}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{validate}}{How to construct the internal validation data. This parameter can be either \code{NULL},
a ratio in $(0, 1)$, \code{"test"}, or \code{"predefined"}.}

\item{\code{loss}}{(\code{\link{TorchLoss}})\cr
The torch loss.}

\item{\code{optimizer}}{(\code{\link{TorchOptimizer}})\cr
The torch optimizer.}

\item{\code{callbacks}}{(\code{list()} of \code{\link{TorchCallback}}s)\cr
List of torch callbacks.
The ids will be set as the names.}

\item{\code{internal_valid_scores}}{Retrieves the internal validation scores as a named \code{list()}.
Specify the \verb{$validate} field and the \code{measures_valid} parameter to configure this.
Returns \code{NULL} if learner is not trained yet.}

\item{\code{internal_tuned_values}}{When early stopping is activate, this returns a named list with the early-stopped epochs,
otherwise an empty list is returned.
Returns \code{NULL} if learner is not trained yet.}

\item{\code{marshaled}}{(\code{logical(1)})\cr
Whether the learner is marshaled.}

\item{\code{network}}{(\code{\link[torch:nn_module]{nn_module()}})\cr
Shortcut for \code{learner$model$network}.}

\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
The parameter set}

\item{\code{hash}}{(\code{character(1)})\cr
Hash (unique identifier) for this object.}

\item{\code{phash}}{(\code{character(1)})\cr
Hash (unique identifier) for this partial object, excluding some components
which are varied systematically during tuning (parameter values).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerTorch-new}{\code{LearnerTorch$new()}}
\item \href{#method-LearnerTorch-format}{\code{LearnerTorch$format()}}
\item \href{#method-LearnerTorch-print}{\code{LearnerTorch$print()}}
\item \href{#method-LearnerTorch-marshal}{\code{LearnerTorch$marshal()}}
\item \href{#method-LearnerTorch-unmarshal}{\code{LearnerTorch$unmarshal()}}
\item \href{#method-LearnerTorch-dataset}{\code{LearnerTorch$dataset()}}
\item \href{#method-LearnerTorch-clone}{\code{LearnerTorch$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerTorch-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerTorch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerTorch$new(
  id,
  task_type,
  param_set,
  properties,
  man,
  label,
  feature_types,
  optimizer = NULL,
  loss = NULL,
  packages = character(),
  predict_types = NULL,
  callbacks = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
The id for of the new object.}

\item{\code{task_type}}{(\code{character(1)})\cr
The task type.}

\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}} or \code{alist()})\cr
Either a parameter set, or an \code{alist()} containing different values of self,
e.g. \code{alist(private$.param_set1, private$.param_set2)}, from which a \code{\link[paradox:ParamSet]{ParamSet}} collection
should be created.}

\item{\code{properties}}{(\code{character()})\cr
The properties of the object.
See \code{\link[mlr3:mlr_reflections]{mlr_reflections$learner_properties}} for available values.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}

\item{\code{label}}{(\code{character(1)})\cr
Label for the new instance.}

\item{\code{feature_types}}{(\code{character()})\cr
The feature types.
See \code{\link[mlr3:mlr_reflections]{mlr_reflections$task_feature_types}} for available values,
Additionally, \code{"lazy_tensor"} is supported.}

\item{\code{optimizer}}{(\code{NULL} or \code{\link{TorchOptimizer}})\cr
The optimizer to use for training.
Defaults to adam.}

\item{\code{loss}}{(\code{NULL} or \code{\link{TorchLoss}})\cr
The loss to use for training.
Defaults to MSE for regression and cross entropy for classification.}

\item{\code{packages}}{(\code{character()})\cr
The R packages this object depends on.}

\item{\code{predict_types}}{(\code{character()})\cr
The predict types.
See \code{\link[mlr3:mlr_reflections]{mlr_reflections$learner_predict_types}} for available values.
For regression, the default is \code{"response"}.
For classification, this defaults to \code{"response"} and \code{"prob"}.
To deviate from the defaults, it is necessary to overwrite the private \verb{$.encode_prediction()}
method, see section \emph{Inheriting}.}

\item{\code{callbacks}}{(\code{list()} of \code{\link{TorchCallback}}s)\cr
The callbacks to use for training.
Defaults to an empty\code{ list()}, i.e. no callbacks.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerTorch-format"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerTorch-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerTorch$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerTorch-print"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerTorch-print}{}}}
\subsection{Method \code{print()}}{
Prints the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerTorch$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(any)\cr
Currently unused.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerTorch-marshal"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerTorch-marshal}{}}}
\subsection{Method \code{marshal()}}{
Marshal the learner.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerTorch$marshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(any)\cr
Additional parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerTorch-unmarshal"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerTorch-unmarshal}{}}}
\subsection{Method \code{unmarshal()}}{
Unmarshal the learner.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerTorch$unmarshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(any)\cr
Additional parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerTorch-dataset"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerTorch-dataset}{}}}
\subsection{Method \code{dataset()}}{
Create the dataset for a task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerTorch$dataset(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\code{\link[mlr3:Task]{Task}}\cr
The task}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[torch:dataset]{dataset}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerTorch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerTorch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerTorch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
