% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelines.R
\name{mlr_graphs_survtoregr}
\alias{mlr_graphs_survtoregr}
\alias{pipeline_survtoregr}
\title{Survival to Regression Reduction Pipeline}
\usage{
pipeline_survtoregr(
  method = 1,
  regr_learner = lrn("regr.featureless"),
  distrcompose = TRUE,
  distr_estimator = lrn("surv.kaplan"),
  regr_se_learner = NULL,
  surv_learner = lrn("surv.coxph"),
  survregr_params = list(method = "ipcw", estimator = "kaplan", alpha = 1),
  distrcompose_params = list(form = "aft"),
  probregr_params = list(dist = "Normal"),
  learnercv_params = list(resampling.method = "insample"),
  graph_learner = FALSE
)
}
\arguments{
\item{method}{\code{integer(1)}\cr
Reduction method to use, corresponds to those in \code{details}. Default is \code{1}.}

\item{regr_learner}{\link[mlr3:LearnerRegr]{LearnerRegr}\cr
Regression learner to fit to the transformed \link[mlr3:TaskRegr]{TaskRegr}. If \code{regr_se_learner} is
\code{NULL} in method \code{2}, then \code{regr_learner} must have \code{se} predict_type.}

\item{distrcompose}{\code{logical(1)}\cr
For methods \code{1} and \code{3} if \code{TRUE} (default) then \link{PipeOpDistrCompositor} is utilised to
transform the deterministic predictions to a survival distribution.}

\item{distr_estimator}{\link{LearnerSurv}\cr
For methods \code{1} and \code{3} if \code{distrcompose = TRUE} then specifies the learner to estimate the
baseline hazard, must have predict_type \code{distr}.}

\item{regr_se_learner}{\link[mlr3:LearnerRegr]{LearnerRegr}\cr
For method \code{2} if \code{regr_learner} is not used to predict the \code{se} then a \code{LearnerRegr} with \code{se}
predict_type must be provided.}

\item{surv_learner}{\link{LearnerSurv}\cr
For method \code{3}, a \link{LearnerSurv} with \code{lp} predict type to estimate linear predictors.}

\item{survregr_params}{\code{list()}\cr
Parameters passed to \link{PipeOpTaskSurvRegr}, default are survival to regression transformation
via \code{ipcw}, with weighting determined by Kaplan-Meier and no additional penalty for censoring.}

\item{distrcompose_params}{\code{list()}\cr
Parameters passed to \link{PipeOpDistrCompositor}, default is accelerated failure time model form.}

\item{probregr_params}{\code{list()}\cr
Parameters passed to \link{PipeOpProbregrCompositor}, default is \link[distr6:Normal]{Normal}
distribution for composition.}

\item{learnercv_params}{\code{list()}\cr
Parameters passed to \link[mlr3pipelines:PipeOpLearnerCV]{PipeOpLearnerCV}, default is to use
insampling.}

\item{graph_learner}{\code{logical(1)}\cr
If \code{TRUE} returns wraps the \link[mlr3pipelines:Graph]{Graph} as a
\link[mlr3pipelines:GraphLearner]{GraphLearner} otherwise (default) returns as a \code{Graph}.}
}
\value{
\link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or \link[mlr3pipelines:GraphLearner]{mlr3pipelines::GraphLearner}
}
\description{
Wrapper around multiple \link[mlr3pipelines:PipeOp]{PipeOp}s to help in creation
of complex survival to reduction methods. Three reductions are currently implemented,
see details.
}
\details{
Three reduction strategies are implemented, these are:

\enumerate{
\item Survival to Deterministic Regression A
\enumerate{
\item \link{PipeOpTaskSurvRegr} Converts \link{TaskSurv} to \link[mlr3:TaskRegr]{TaskRegr}.
\item A \link{LearnerRegr} is fit and predicted on the new \code{TaskRegr}.
\item \link{PipeOpPredRegrSurv} transforms the resulting \link[mlr3:PredictionRegr]{PredictionRegr}
to \link{PredictionSurv}.
\item Optionally: \link{PipeOpDistrCompositor} is used to compose a \code{distr} predict_type from the
predicted \code{response} predict_type.
}
\item Survival to Probabilistic Regression
\enumerate{
\item \link{PipeOpTaskSurvRegr} Converts \link{TaskSurv} to \link[mlr3:TaskRegr]{TaskRegr}.
\item A \link{LearnerRegr} is fit on the new \code{TaskRegr} to predict \code{response}, optionally a second
\code{LearnerRegr} can be fit to predict \code{se}.
\item \link{PipeOpProbregrCompositor} composes a \code{distr} prediction from the learner(s).
\item \link{PipeOpPredRegrSurv} transforms the resulting \link[mlr3:PredictionRegr]{PredictionRegr}
to \link{PredictionSurv}.
}
\item Survival to Deterministic Regression B
\enumerate{
\item \link[mlr3pipelines:PipeOpLearnerCV]{PipeOpLearnerCV} cross-validates and makes predictions from
a linear \link{LearnerSurv} with \code{lp} predict type on the original \link{TaskSurv}.
\item \link{PipeOpTaskSurvRegr} transforms the \code{lp} predictions into the target of a
\link[mlr3:TaskRegr]{TaskRegr} with the same features as the original \link{TaskSurv}.
\item A \link{LearnerRegr} is fit and predicted on the new \code{TaskRegr}.
\item \link{PipeOpPredRegrSurv} transforms the resulting \link[mlr3:PredictionRegr]{PredictionRegr}
to \link{PredictionSurv}.
\item Optionally: \link{PipeOpDistrCompositor} is used to compose a \code{distr} predict_type from the
predicted \code{lp} predict_type.
}
}

Interpretation:
\enumerate{
\item Once a dataset has censoring removed (by a given method) then a regression
learner can predict the survival time as the \code{response}.
\item This is a very similar reduction to the first method with the main difference
being the distribution composition. In the first case this is composed in a survival framework
by assuming a linear model form and baseline hazard estimator, in the second case the
composition is in a regression framework. The latter case could result in problematic negative
predictions and should therefore be interpreted with caution, however a wider choice of
distributions makes it a more flexible composition.
\item This is a rarer use-case that bypasses censoring not be removing it but instead
by first predicting the linear predictor from a survival model and fitting a regression
model on these predictions. The resulting regression predictions can then be viewed as the linear
predictors of the new data, which can ultimately be composed to a distribution.
}
}
\examples{
\dontrun{
library("mlr3")
library("mlr3pipelines")

task = tgen("simsurv")$generate(10)

# method 1 with censoring deletion, compose to distribution
pipe = ppl(
  "survtoregr",
  method = 1,
  regr_learner = lrn("regr.featureless"),
  distrcompose = TRUE,
  survregr_params = list(method = "delete")
)
pipe$train(task)
pipe$predict(task)

# method 2 with censoring imputation (mrl), one regr learner
pipe = ppl(
  "survtoregr",
  method = 2,
  regr_learner = lrn("regr.featureless", predict_type = "se"),
  survregr_params = list(method = "mrl")
)
pipe$train(task)
pipe$predict(task)

# method 3 with censoring omission and no composition, insample resampling
pipe = ppl(
  "survtoregr",
  method = 3,
  regr_learner = lrn("regr.featureless"),
  distrcompose = FALSE,
  surv_learner = lrn("surv.coxph"),
  survregr_params = list(method = "omission")
)
pipe$train(task)
pipe$predict(task)
}

}
\seealso{
Other pipelines: 
\code{\link{mlr_graphs_crankcompositor}},
\code{\link{mlr_graphs_distrcompositor}},
\code{\link{mlr_graphs_probregrcompositor}},
\code{\link{mlr_graphs_survaverager}},
\code{\link{mlr_graphs_survbagging}}
}
\concept{pipelines}
