% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvMAESE.R
\name{MeasureSurvMAESE}
\alias{MeasureSurvMAESE}
\alias{mlr_measures_surv.maeSE}
\title{Standard Error of Mean Absolute Error Survival Measure}
\description{
Calculates the standard error of \link{MeasureSurvMAE}.

The standard error of the MAE, L, is approximated via
\deqn{se(L) = sd(L)/\sqrt{N}}{se(L) = sd(L)/\sqrt N}

Censored observations in the test set are ignored.
}
\section{Dictionary}{

This \link[mlr3:Measure]{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_measures]{mlr_measures} or with the associated sugar function \link[mlr3:msr]{msr()}:\preformatted{MeasureSurvMAESE$new()
mlr_measures$get("surv.maeSE")
msr("surv.maeSE")
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{response}
}
}

\seealso{
Other survival measures: 
\code{\link{MeasureSurvBeggC}},
\code{\link{MeasureSurvChamblessAUC}},
\code{\link{MeasureSurvGonenC}},
\code{\link{MeasureSurvGrafSE}},
\code{\link{MeasureSurvGraf}},
\code{\link{MeasureSurvHarrellC}},
\code{\link{MeasureSurvHungAUC}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}},
\code{\link{MeasureSurvMAE}},
\code{\link{MeasureSurvMSESE}},
\code{\link{MeasureSurvMSE}},
\code{\link{MeasureSurvNagelkR2}},
\code{\link{MeasureSurvOQuigleyR2}},
\code{\link{MeasureSurvRMSESE}},
\code{\link{MeasureSurvRMSE}},
\code{\link{MeasureSurvSongAUC}},
\code{\link{MeasureSurvSongTNR}},
\code{\link{MeasureSurvSongTPR}},
\code{\link{MeasureSurvUnoAUC}},
\code{\link{MeasureSurvUnoC}},
\code{\link{MeasureSurvUnoTNR}},
\code{\link{MeasureSurvUnoTPR}},
\code{\link{MeasureSurvXuR2}}

Other response survival measures: 
\code{\link{MeasureSurvMAE}},
\code{\link{MeasureSurvMSESE}},
\code{\link{MeasureSurvMSE}},
\code{\link{MeasureSurvRMSESE}},
\code{\link{MeasureSurvRMSE}}
}
\concept{response survival measures}
\concept{survival measures}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3proba:MeasureSurv]{mlr3proba::MeasureSurv}} -> \code{MeasureSurvMAESE}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MeasureSurvMAESE$new()}}
\item \href{#method-clone}{\code{MeasureSurvMAESE$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate">}\href{../../mlr3/html/Measure.html#method-aggregate}{\code{mlr3::Measure$aggregate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format">}\href{../../mlr3/html/Measure.html#method-format}{\code{mlr3::Measure$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help">}\href{../../mlr3/html/Measure.html#method-help}{\code{mlr3::Measure$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print">}\href{../../mlr3/html/Measure.html#method-print}{\code{mlr3::Measure$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score">}\href{../../mlr3/html/Measure.html#method-score}{\code{mlr3::Measure$score()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvMAESE$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvMAESE$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
