% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvGamboost.R
\name{LearnerSurvGamboost}
\alias{LearnerSurvGamboost}
\alias{mlr_learners_surv.gamboost}
\title{Gradient Boosting for Additive Models Survival Learner}
\description{
Calls \code{\link[mboost:gamboost]{mboost::gamboost()}}.
\itemize{
\item lp is predicted by \code{\link[mboost:predict.mboost]{mboost::predict.mboost()}}
\item distr is predicted by \code{\link[mboost:survFit]{mboost::survFit()}} which assumes a PH fit with a Breslow estimator
\item \code{crank} is identical to \code{lp}
}

The \code{dist} parameter is specified slightly differently than in \CRANpkg{mboost}. Whereas the latter
takes in objects, in this learner instead a string is specified in order to identify which distribution
to use. As the default in \CRANpkg{mboost} is the Gaussian family, which is not compatible with
survival models, instead we have by default \code{"coxph"}.

If the value given to the \code{Family} parameter is "custom.family" then an object of class
\code{\link[mboost:Family]{mboost::Family()}} needs to be passed to the \code{custom.family} parameter.

The only difference between \link{LearnerSurvGamboost} and \link{LearnerSurvMboost} is that the latter function
allows one to specify default degrees of freedom for smooth effects specified via
\code{baselearner = "bbs"}. In all other cases, degrees of freedom need to be set manually via a
specific definition of the corresponding base-learner.
}
\section{Dictionary}{

This \link[mlr3:Learner]{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_learners]{mlr_learners} or with the associated sugar function \link[mlr3:lrn]{lrn()}:\preformatted{LearnerSurvGamboost$new()
mlr_learners$get("surv.gamboost")
lrn("surv.gamboost")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{distr, crank, lp}
\item Feature Types: \verb{integer, numeric, factor, logical}
\item Properties: \code{-}
\item Packages: \CRANpkg{mboost} \CRANpkg{distr6} \CRANpkg{survival}
}
}

\examples{
library(mlr3)
task = tgen("simsurv")$generate(20)
learner = lrn("surv.gamboost")
learner$param_set$values = mlr3misc::insert_named(learner$param_set$values,
     list(dfbase = 3, center = TRUE, baselearner = "bols"))
resampling = rsmp("cv", folds = 2)
resample(task, learner, resampling)
}
\references{
\cite{mlr3proba}{buehlmann_2003}

\cite{mlr3proba}{buehlmann_2007}

\cite{mlr3proba}{kneib_2008}

\cite{mlr3proba}{schmid_2008}

\cite{mlr3proba}{hothorn_2010}

\cite{mlr3proba}{hofner_2012}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvObliqueRSF}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3proba:LearnerSurv]{mlr3proba::LearnerSurv}} -> \code{LearnerSurvGamboost}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LearnerSurvGamboost$new()}}
\item \href{#method-clone}{\code{LearnerSurvGamboost$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format">}\href{../../mlr3/html/Learner.html#method-format}{\code{mlr3::Learner$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help">}\href{../../mlr3/html/Learner.html#method-help}{\code{mlr3::Learner$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict">}\href{../../mlr3/html/Learner.html#method-predict}{\code{mlr3::Learner$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata">}\href{../../mlr3/html/Learner.html#method-predict_newdata}{\code{mlr3::Learner$predict_newdata()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print">}\href{../../mlr3/html/Learner.html#method-print}{\code{mlr3::Learner$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset">}\href{../../mlr3/html/Learner.html#method-reset}{\code{mlr3::Learner$reset()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train">}\href{../../mlr3/html/Learner.html#method-train}{\code{mlr3::Learner$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvGamboost$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvGamboost$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
