% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo_sort.R
\name{topo_sort}
\alias{topo_sort}
\title{Topological Sorting of Dependency Graphs}
\usage{
topo_sort(nodes)
}
\arguments{
\item{nodes}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Has 2 columns:
\itemize{
\item \code{id} of type \code{character}, contains all node labels.
\item \code{parents} of type \code{list} of \code{character}, contains all direct parents label of \code{id}.
}}
}
\value{
(\code{\link[data.table:data.table]{data.table::data.table()}}) with columns \code{id}, \code{depth}, sorted topologically for IDs.
}
\description{
Topologically sort a graph, where we are passed node labels and a list of direct
parents for each node, as labels, too.
A node can be 'processed' if all its parents have been 'processed',
and hence occur at previous indices in the resulting sorting.
Returns a table, in topological row order for IDs, and an entry \code{depth},
which encodes the topological layer, starting at 0.
So nodes with \code{depth == 0} are the ones with no dependencies,
and the one with maximal \code{depth} are the ones on which nothing else depends on.
}
\examples{
nodes = rowwise_table(
  ~id, ~parents,
  "a", "b",
  "b", "c",
  "c", character()
)
topo_sort(nodes)
}
