% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorShadowVariableSearch.R
\name{FSelectorShadowVariableSearch}
\alias{FSelectorShadowVariableSearch}
\title{Feature Selection via Sequential Search with Shadow Variables}
\source{
Thomas J, Hepp T, Mayr A, Bischl B (2017).
\dQuote{Probing for Sparse and Fast Variable Selection with Model-Based Boosting.}
\emph{Computational and Mathematical Methods in Medicine}, \bold{2017}, 1--8.
\doi{10.1155/2017/1421409}.
Wu Y, Boos DD, Stefanski LA (2007).
\dQuote{Controlling Variable Selection by the Addition of Pseudovariables.}
\emph{Journal of the American Statistical Association}, \bold{102}(477), 235--243.
\doi{10.1198/016214506000000843}.
}
\description{
\code{FSelectorShadowVariableSearch} class that implements a sequential search with shadow variables.
}
\note{
\code{FSelectorShadowVariableSearch} terminates itself and should be used with \link{TerminatorNone}.
}
\section{Dictionary}{

This \link{FSelector} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_fselectors} or with the associated sugar function \code{\link[=fs]{fs()}}:\preformatted{mlr_fselectors$get("shadow_variable_search")
fs("shadow_variable_search")
}
}

\examples{
library(mlr3)

instance = FSelectInstanceSingleCrit$new(
  task = tsk("iris"),
  learner = lrn("classif.rpart"),
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  terminator = trm("none")
)

fselector = fs("shadow_variable_search")
\donttest{
# Modifies the instance by reference
fselector$optimize(instance)

# Returns best scoring evaluation
instance$result

# Allows access of data.table of full path of all evaluations
as.data.table(instance$archive)}
}
\section{Super class}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{FSelectorShadowVariableSearch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{FSelectorShadowVariableSearch$new()}}
\item \href{#method-optimization_path}{\code{FSelectorShadowVariableSearch$optimization_path()}}
\item \href{#method-clone}{\code{FSelectorShadowVariableSearch$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format">}\href{../../mlr3fselect/html/FSelector.html#method-format}{\code{mlr3fselect::FSelector$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="optimize">}\href{../../mlr3fselect/html/FSelector.html#method-optimize}{\code{mlr3fselect::FSelector$optimize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print">}\href{../../mlr3fselect/html/FSelector.html#method-print}{\code{mlr3fselect::FSelector$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.`
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorShadowVariableSearch$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimization_path"></a>}}
\if{latex}{\out{\hypertarget{method-optimization_path}{}}}
\subsection{Method \code{optimization_path()}}{
Returns the optimization path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorShadowVariableSearch$optimization_path(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{FSelectInstanceSingleCrit})\cr
Instance optimized with \link{FSelectorShadowVariableSearch}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[data.table:data.table]{data.table::data.table}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorShadowVariableSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
