% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorRFECV.R
\name{mlr_fselectors_rfecv}
\alias{mlr_fselectors_rfecv}
\alias{FSelectorRFECV}
\title{Feature Selection with Recursive Feature Elimination with Cross Validation}
\description{
Feature selection using the Recursive Feature Elimination with Cross-Validation (RFE-CV) algorithm.
See \link{FSelectorRFE} for a description of the base algorithm.
RFE-CV runs a recursive feature elimination in each iteration of a cross-validation to determine the optimal number of features.
Then a recursive feature elimination is run again on the complete dataset with the optimal number of features as the final feature set size.
The performance of the optimal feature set is calculated on the complete data set and should not be reported as the performance of the final model.
Only works with \link[mlr3:Learner]{mlr3::Learner}s that can calculate importance scores (see the section on optional extractors in \link[mlr3:Learner]{mlr3::Learner}).
}
\details{
The resampling strategy is changed during the feature selection.
The resampling strategy passed to the instance (\code{resampling}) is used to determine the optimal number of features.
Usually, a cross-validation strategy is used and a recursive feature elimination is run in each iteration of the cross-validation.
Internally, \link[mlr3:mlr_resamplings_custom]{mlr3::ResamplingCustom} is used to emulate this part of the algorithm.
In the final recursive feature elimination run the resampling strategy is changed to \link[mlr3:mlr_resamplings_insample]{mlr3::ResamplingInsample} i.e. the complete data set is used for training and testing.

The feature selection terminates itself when the optimal number of features is reached.
It is not necessary to set a termination criterion.
}
\section{Archive}{

The \link{ArchiveFSelect} holds the following additional columns:
\itemize{
\item \code{"iteration"} (\code{integer(1)})\cr
The resampling iteration in which the feature subset was evaluated.
\item \code{"importance"} (\code{numeric()})\cr
The importance score vector of the feature subset.
}
}

\section{Resources}{

The \href{https://mlr-org.com/gallery.html}{gallery} features a collection of case studies and demos about optimization.
\itemize{
\item Utilize the built-in feature importance of models with \href{https://mlr-org.com/gallery/optimization/2023-02-07-recursive-feature-elimination/}{Recursive Feature Elimination}.
}
}

\section{Dictionary}{

This \link{FSelector} can be instantiated with the associated sugar function \code{\link[=fs]{fs()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fs("rfe")
}\if{html}{\out{</div>}}
}

\section{Control Parameters}{

\describe{
\item{\code{n_features}}{\code{integer(1)}\cr
The number of features to select.
By default half of the features are selected.}
\item{\code{feature_fraction}}{\code{double(1)}\cr
Fraction of features to retain in each iteration.
The default 0.5 retrains half of the features.}
\item{\code{feature_number}}{\code{integer(1)}\cr
Number of features to remove in each iteration.}
\item{\code{subset_sizes}}{\code{integer()}\cr
Vector of number of features to retain in each iteration.
Must be sorted in decreasing order.}
\item{\code{recursive}}{\code{logical(1)}\cr
If \code{TRUE} (default), the feature importance is calculated in each iteration.}
}

The parameter \code{feature_fraction}, \code{feature_number} and \code{subset_sizes} are mutually exclusive.
}

\examples{
# Feature Selection
\donttest{

# retrieve task and load learner
task = tsk("penguins")
learner = lrn("classif.rpart")

# run feature selection on the Palmer Penguins data set
instance = fselect(
  fselector = fs("rfecv"),
  task = task,
  learner = learner,
  resampling = rsmp("cv", folds = 3),
  measure = msr("classif.ce"),
  store_models = TRUE
)

# best performing feature subset
instance$result

# all evaluated feature subsets
as.data.table(instance$archive)

# subset the task and fit the final model
task$select(instance$result_feature_set)
learner$train(task)
}
}
\seealso{
Other FSelector: 
\code{\link{mlr_fselectors}},
\code{\link{mlr_fselectors_design_points}},
\code{\link{mlr_fselectors_exhaustive_search}},
\code{\link{mlr_fselectors_genetic_search}},
\code{\link{mlr_fselectors_random_search}},
\code{\link{mlr_fselectors_rfe}},
\code{\link{mlr_fselectors_sequential}},
\code{\link{mlr_fselectors_shadow_variable_search}}
}
\concept{FSelector}
\section{Super class}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{FSelectorRFECV}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FSelectorRFECV-new}{\code{FSelectorRFECV$new()}}
\item \href{#method-FSelectorRFECV-clone}{\code{FSelectorRFECV$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-format'><code>mlr3fselect::FSelector$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="help"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-help'><code>mlr3fselect::FSelector$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="optimize"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-optimize'><code>mlr3fselect::FSelector$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-print'><code>mlr3fselect::FSelector$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorRFECV-new"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorRFECV-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorRFECV$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorRFECV-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorRFECV-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorRFECV$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
