% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adult.R
\docType{data}
\name{adult}
\alias{adult}
\alias{adult_test}
\alias{adult_train}
\title{Adult Dataset}
\source{
Dua, Dheeru, Graff, Casey (2017).
\dQuote{UCI Machine Learning Repository.}
\url{http://archive.ics.uci.edu/ml/}.
}
\description{
Dataset used to predict whether income exceeds $50K/yr based on census data.
Also known as "Census Income" dataset
Train dataset contains 13 features and 30178 observations.
Test dataset contains 13 features and 15315 observations.
Target column is "target": A binary factor where 1: <=50K and 2: >50K for annual income.
The column \code{"sex"} is set as protected attribute.
}
\section{Pre-processing}{

\itemize{
\item \code{fnlwgt} Remove final weight, which is the number of people the census believes the entry represents
\item \code{native-country} Remove Native Country, which is the country of origin for an individual
\item Rows containing \code{NA} in workclass and occupation have been removed.
\item Pre-processing inspired by article: @url https://cseweb.ucsd.edu//classes/sp15/cse190-c/reports/sp15/048.pdf
}
}

\section{Metadata}{

\itemize{
\item (integer) age: The age of the individuals
\item (factor) workclass: A general term to represent the employment status of an individual
\item (factor) education: The highest level of education achieved by an individual.
\item (integer) education_num: the highest level of education achieved in numerical form.
\item (factor) marital_status: marital status of an individual.
\item (factor) occupation: the general type of occupation of an individual
\item (factor) relationship: twhether the individual is in a relationship-
\item (factor) race: Descriptions of an individual’s race
\item (factor) sex: the biological sex of the individual
\item (integer) captain-gain: capital gains for an individual
\item (integer) captain-loss: capital loss for an individual
\item (integer) hours-per-week: the hours an individual has reported to work per week
\item (factor) target: whether or not an individual makes more than $50,000 annually
}
}

\examples{
data("adult_test", package = "mlr3fairness")
data("adult_train", package = "mlr3fairness")
}
\keyword{data}
