% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingLOO.R
\name{mlr_resamplings_loo}
\alias{mlr_resamplings_loo}
\alias{ResamplingLOO}
\title{Leave-One-Out Cross-Validation}
\description{
Splits data using leave-one-observation-out.
This is identical to cross-validation with the number of folds set
to the number of observations.

If this resampling is combined with the grouping features of tasks,
it is possible to create custom splits based on an arbitrary factor variable,
see the examples.
}
\section{Dictionary}{

This \link{Resampling} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_resamplings} or with the associated sugar function \code{\link[=rsmp]{rsmp()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_resamplings$get("loo")
rsmp("loo")
}\if{html}{\out{</div>}}
}

\examples{
# Create a task with 10 observations
task = tsk("penguins")
task$filter(1:10)

# Instantiate Resampling
loo = rsmp("loo")
loo$instantiate(task)

# Individual sets:
loo$train_set(1)
loo$test_set(1)

# Disjunct sets:
intersect(loo$train_set(1), loo$test_set(1))

# Internal storage:
loo$instance # vector

# Combine with group feature of tasks:
task = tsk("penguins")
task$set_col_roles("island", add_to = "group")
loo$instantiate(task)
loo$iters # one fold for each level of "island"
}
\references{
Bischl B, Mersmann O, Trautmann H, Weihs C (2012).
\dQuote{Resampling Methods for Meta-Model Validation with Recommendations for Evolutionary Computation.}
\emph{Evolutionary Computation}, \bold{20}(2), 249--275.
\doi{10.1162/evco_a_00069}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/03-perf-resampling.html}
\item Package \CRANpkg{mlr3spatiotempcv} for spatio-temporal resamplings.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Resampling]{Resamplings}: \link{mlr_resamplings}
\item \code{as.data.table(mlr_resamplings)} for a table of available \link[=Resampling]{Resamplings} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3spatiotempcv} for additional \link{Resampling}s for spatio-temporal
tasks.
}

Other Resampling: 
\code{\link{Resampling}},
\code{\link{mlr_resamplings_bootstrap}},
\code{\link{mlr_resamplings_custom_cv}},
\code{\link{mlr_resamplings_custom}},
\code{\link{mlr_resamplings_cv}},
\code{\link{mlr_resamplings_holdout}},
\code{\link{mlr_resamplings_insample}},
\code{\link{mlr_resamplings_repeated_cv}},
\code{\link{mlr_resamplings_subsampling}},
\code{\link{mlr_resamplings}}
}
\concept{Resampling}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingLOO}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{(\code{integer(1)})\cr
Returns the number of resampling iterations which is the number of rows of the task
provided to instantiate. Is \code{NA} if the resampling has not been instantiated.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingLOO-new}{\code{ResamplingLOO$new()}}
\item \href{#method-ResamplingLOO-clone}{\code{ResamplingLOO$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="instantiate"><a href='../../mlr3/html/Resampling.html#method-Resampling-instantiate'><code>mlr3::Resampling$instantiate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingLOO-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingLOO-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingLOO$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingLOO-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingLOO-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingLOO$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
