% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResampleResult.R
\name{ResampleResult}
\alias{ResampleResult}
\title{Container for Results of \code{resample()}}
\description{
This is the result container object returned by \code{\link[=resample]{resample()}}.

Note that all stored objects are accessed by reference.
Do not modify any object without cloning it first.
}
\section{S3 Methods}{

\itemize{
\item \code{as.data.table(rr, reassemble_learners = TRUE, convert_predictions = TRUE, predict_sets = "test")}\cr
\link{ResampleResult} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a tabular view of the internal data.
\item \code{c(...)}\cr
(\link{ResampleResult}, ...) -> \link{BenchmarkResult}\cr
Combines multiple objects convertible to \link{BenchmarkResult} into a new \link{BenchmarkResult}.
}
}

\examples{
task = tsk("iris")
learner = lrn("classif.rpart")
resampling = rsmp("cv", folds = 3)
rr = resample(task, learner, resampling)
print(rr)

rr$aggregate(msr("classif.acc"))
rr$prediction()
rr$prediction()$confusion
rr$warnings
rr$errors
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{(\code{ResultData})\cr
Internal data storage object of type \code{ResultData}.
We discourage users to directly work with this field.
Use \code{as.table.table(ResampleResult)} instead.}

\item{\code{view}}{(\code{character(1)})\cr
Subset of uhashes in the \link{ResultData} object to operate on.
This field is for internal optimizations, i.e. to avoid unnecessary cloning.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{task_type}}{(\code{character(1)})\cr
Task type of objects in the \code{ResampleResult}, e.g. \code{"classif"} or \code{"regr"}.
This is \code{NA} for empty \link{ResampleResult}s.}

\item{\code{uhash}}{(\code{character(1)})\cr
Unique hash for this object.}

\item{\code{task}}{(\link{Task})\cr
The task \code{\link[=resample]{resample()}} operated on.}

\item{\code{learner}}{(\link{Learner})\cr
Learner prototype \code{\link[=resample]{resample()}} operated on.
For a list of \strong{trained} learners, see methods \verb{$learners()}.}

\item{\code{resampling}}{(\link{Resampling})\cr
Instantiated \link{Resampling} object which stores the splits into training and test.}

\item{\code{learners}}{(list of \link{Learner})\cr
List of trained learners, sorted by resampling iteration.}

\item{\code{warnings}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
A table with all warning messages.
Column names are \code{"iteration"} and \code{"msg"}.
Note that there can be multiple rows per resampling iteration if multiple warnings have been recorded.}

\item{\code{errors}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
A table with all error messages.
Column names are \code{"iteration"} and \code{"msg"}.
Note that there can be multiple rows per resampling iteration if multiple errors have been recorded.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ResampleResult$new()}}
\item \href{#method-format}{\code{ResampleResult$format()}}
\item \href{#method-print}{\code{ResampleResult$print()}}
\item \href{#method-help}{\code{ResampleResult$help()}}
\item \href{#method-prediction}{\code{ResampleResult$prediction()}}
\item \href{#method-predictions}{\code{ResampleResult$predictions()}}
\item \href{#method-score}{\code{ResampleResult$score()}}
\item \href{#method-aggregate}{\code{ResampleResult$aggregate()}}
\item \href{#method-filter}{\code{ResampleResult$filter()}}
\item \href{#method-clone}{\code{ResampleResult$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
An alternative construction method is provided by \code{\link[=as_resample_result]{as_resample_result()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResampleResult$new(data = ResultData$new(), view = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\link{ResultData} | \code{\link[=data.table]{data.table()}})\cr
An object of type \link{ResultData}, either extracted from another \link{ResampleResult}, another
\link{BenchmarkResult}, or manually constructed with \code{\link[=as_result_data]{as_result_data()}}.}

\item{\code{view}}{(\code{character()})\cr
Single \code{uhash} of the \link{ResultData} to operate on.
Used internally for optimizations.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResampleResult$format()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResampleResult$print()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-help"></a>}}
\if{latex}{\out{\hypertarget{method-help}{}}}
\subsection{Method \code{help()}}{
Opens the corresponding help page referenced by field \verb{$man}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResampleResult$help()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-prediction"></a>}}
\if{latex}{\out{\hypertarget{method-prediction}{}}}
\subsection{Method \code{prediction()}}{
Combined \link{Prediction} of all individual resampling iterations, and all provided predict sets.
Note that performance measures do not operate on this object,
but instead on each prediction object separately and then combine the performance scores
with the aggregate function of the respective \link{Measure}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResampleResult$prediction(predict_sets = "test")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predict_sets}}{(\code{character()})\cr}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Prediction}.
Subset of \verb{\{"train", "test"\}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predictions"></a>}}
\if{latex}{\out{\hypertarget{method-predictions}{}}}
\subsection{Method \code{predictions()}}{
List of prediction objects, sorted by resampling iteration.
If multiple sets are given, these are combined to a single one for each iteration.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResampleResult$predictions(predict_sets = "test")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predict_sets}}{(\code{character()})\cr
Subset of \verb{\{"train", "test"\}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of \link{Prediction} objects, one per element in \code{predict_sets}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-score"></a>}}
\if{latex}{\out{\hypertarget{method-score}{}}}
\subsection{Method \code{score()}}{
Returns a table with one row for each resampling iteration, including all involved objects:
\link{Task}, \link{Learner}, \link{Resampling}, iteration number (\code{integer(1)}), and \link{Prediction}.
Additionally, a column with the individual (per resampling iteration) performance is added
for each \link{Measure} in \code{measures},
named with the id of the respective measure id.
If \code{measures} is \code{NULL}, \code{measures} defaults to the return value of \code{\link[=default_measures]{default_measures()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResampleResult$score(
  measures = NULL,
  ids = TRUE,
  conditions = FALSE,
  predict_sets = "test"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measures}}{(\link{Measure} | list of \link{Measure})\cr
Measure(s) to calculate.}

\item{\code{ids}}{(\code{logical(1)})\cr
If \code{ids} is \code{TRUE}, extra columns with the ids of objects (\code{"task_id"}, \code{"learner_id"}, \code{"resampling_id"})
are added to the returned table.
These allow to subset more conveniently.}

\item{\code{conditions}}{(\code{logical(1)})\cr
Adds condition messages (\code{"warnings"}, \code{"errors"}) as extra
list columns of character vectors to the returned table}

\item{\code{predict_sets}}{(\code{character()})\cr
Vector of predict sets (\verb{\{"train", "test"\}}) to construct the \link{Prediction} objects from.
Default is \code{"test"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-aggregate"></a>}}
\if{latex}{\out{\hypertarget{method-aggregate}{}}}
\subsection{Method \code{aggregate()}}{
Calculates and aggregates performance values for all provided measures, according to the
respective aggregation function in \link{Measure}.
If \code{measures} is \code{NULL}, \code{measures} defaults to the return value of \code{\link[=default_measures]{default_measures()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResampleResult$aggregate(measures = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measures}}{(\link{Measure} | list of \link{Measure})\cr
Measure(s) to calculate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Named \code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-filter"></a>}}
\if{latex}{\out{\hypertarget{method-filter}{}}}
\subsection{Method \code{filter()}}{
Subsets the \link{ResampleResult}, reducing it to only keep the iterations specified in \code{iters}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResampleResult$filter(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{(\code{integer()})\cr
Resampling iterations to keep.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns the object itself, but modified \strong{by reference}.
You need to explicitly \verb{$clone()} the object beforehand if you want to keeps
the object in its previous state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResampleResult$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
