% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prediction.R
\name{Prediction}
\alias{Prediction}
\title{Abstract Prediction Object}
\description{
This is the abstract base class for task objects like \link{PredictionClassif} or \link{PredictionRegr}.

Prediction objects store the following information:
\enumerate{
\item The row ids of the test set
\item The corresponding true (observed) response.
\item The corresponding predicted response.
\item Additional predictions based on the class and \code{predict_type}.
E.g., the class probabilities for classification or the estimated standard error for regression.
}

Note that this object is usually constructed via a derived classes, e.g. \link{PredictionClassif} or \link{PredictionRegr}.
}
\section{S3 Methods}{

\itemize{
\item \code{as.data.table(rr)}\cr
\link{Prediction} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Converts the data to a \code{\link[data.table:data.table]{data.table::data.table()}}.
\item \code{c(..., keep_duplicates = TRUE)}\cr
(\link{Prediction}, \link{Prediction}, ...) -> \link{Prediction}\cr
Combines multiple \code{Prediction}s to a single \code{Prediction}.
If \code{keep_duplicates} is \code{FALSE} and there are duplicated row ids,
the data of the former passed objects get overwritten by the data of the later passed objects.
}
}

\seealso{
Other Prediction: 
\code{\link{PredictionClassif}},
\code{\link{PredictionRegr}}
}
\concept{Prediction}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{(named \code{list()})\cr
Internal data structure.}

\item{\code{task_type}}{(\code{character(1)})\cr
Required type of the \link{Task}.}

\item{\code{task_properties}}{(\code{character()})\cr
Required properties of the \link{Task}.}

\item{\code{predict_types}}{(\code{character()})\cr
Set of predict types this object stores.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
Defaults to \code{NA}, but can be set by child classes.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{row_ids}}{(\code{integer()})\cr
Vector of row ids for which predictions are stored.}

\item{\code{truth}}{(\code{any})\cr
True (observed) outcome.}

\item{\code{missing}}{(\code{integer()})\cr
Returns \code{row_ids} for which the predictions are missing or incomplete.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-format}{\code{Prediction$format()}}
\item \href{#method-print}{\code{Prediction$print()}}
\item \href{#method-help}{\code{Prediction$help()}}
\item \href{#method-score}{\code{Prediction$score()}}
\item \href{#method-clone}{\code{Prediction$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Prediction$format()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Prediction$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-help"></a>}}
\subsection{Method \code{help()}}{
Opens the corresponding help page referenced by field \verb{$man}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Prediction$help()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-score"></a>}}
\subsection{Method \code{score()}}{
Calculates the performance for all provided measures
\link{Task} and \link{Learner} may be \code{NULL} for most measures, but some measures need to extract information
from these objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Prediction$score(
  measures = NULL,
  task = NULL,
  learner = NULL,
  train_set = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measures}}{(\link{Measure} | list of \link{Measure})\cr
Measure(s) to calculate.}

\item{\code{task}}{(\link{Task}).}

\item{\code{learner}}{(\link{Learner}).}

\item{\code{train_set}}{(\code{integer()}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Prediction}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Prediction$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
