% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.Learner}
\alias{predict.Learner}
\title{Predict Method for Learners}
\usage{
\method{predict}{Learner}(object, newdata, predict_type = NULL, ...)
}
\arguments{
\item{object}{:: \link{Learner}\cr
Any \link{Learner}.}

\item{newdata}{:: \code{\link[=data.frame]{data.frame()}}\cr
New data to predict on.}

\item{predict_type}{:: \code{character(1)}\cr
The predict type to return.
Set to \code{<Prediction>} to retrieve the complete \link{Prediction} object.
If set to \code{NULL} (default), the first predict type for the respective class of the \link{Learner}
as stored in \link{mlr_reflections} is used.}

\item{...}{:: \code{any}\cr
Hyperparameters to pass down to the \link{Learner}.}
}
\description{
Extends the generic \code{\link[stats:predict]{stats::predict()}} with a method for \link{Learner}.
Note that this function is intended as glue code to be used in third party packages.
We recommend to work with the \link{Learner} directly, i.e. calling \code{learner$predict()}
or \code{learner$predict_newdata()} directly.

Performs the following steps:
\itemize{
\item Sets additional hyperparameters passed to this function.
\item Creates a \link{Prediction} object by calling \code{learner$predict_newdata()}.
\item Returns (subset of) \link{Prediction}.
}
}
\examples{
task = tsk("spam")

learner = lrn("classif.rpart", predict_type = "prob")
learner$train(task)
predict(learner, task$data(1:3), predict_type = "response")
predict(learner, task$data(1:3), predict_type = "prob")
predict(learner, task$data(1:3), predict_type = "<Prediction>")
}
