% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_sugar.R
\name{mlr_sugar}
\alias{mlr_sugar}
\alias{tsk}
\alias{tgen}
\alias{lrn}
\alias{rsmp}
\alias{msr}
\title{Syntactic Sugar for Object Construction}
\usage{
tsk(.key, ...)

tgen(.key, ...)

lrn(.key, ...)

rsmp(.key, ...)

msr(.key, ...)
}
\arguments{
\item{.key}{:: \code{character(1)}\cr
Key passed to the respective \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} to retrieve the object.}

\item{...}{:: named \code{list()}\cr
Named arguments passed to the constructor, to be set as parameters in the \link[paradox:ParamSet]{paradox::ParamSet}, or to be set as public field.
See \code{\link[mlr3misc:dictionary_sugar]{mlr3misc::dictionary_sugar()}} for more details.}
}
\value{
\link[R6:R6Class]{R6::R6Class} of the respective type.
}
\description{
Functions to retrieve objects, set hyperparameters and assign to fields in one go.
Relies on \code{\link[mlr3misc:dictionary_sugar]{mlr3misc::dictionary_sugar()}} to extract objects from the respective \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}:
\itemize{
\item \code{tsk()} for a \link{Task} from \link{mlr_tasks}.
\item \code{tgen()} for a \link{TaskGenerator} from \link{mlr_task_generators}.
\item \code{lrn()} for a \link{Learner} from \link{mlr_learners}.
\item \code{rsmp()} for a \link{Resampling} from \link{mlr_resamplings}.
\item \code{msr()} for a \link{Measure} from \link{mlr_measures}.
}
}
\examples{
# iris task with new id
tsk("iris", id = "iris2")

# classification tree with different hyperparameters
# and predict type set to predict probabilities
lrn("classif.rpart", cp = 0.1, predict_type = "prob")

# multiple learners with predict type 'prob'
lapply(c("classif.featureless", "classif.rpart"), lrn, predict_type = "prob")
}
