% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif_german_credit.R
\name{mlr_tasks_german_credit}
\alias{mlr_tasks_german_credit}
\title{German Credit Classification Task}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskClassif}.}
\source{
Data set originally published on \href{https://archive.ics.uci.edu/ml/datasets/statlog+(german+credit+data)}{UCI}.
This is the preprocessed version taken from package \CRANpkg{evtree}.

Donor:
Professor Dr. Hans Hofmann\cr
Institut für Statistik und Ökonometrie\cr
Universität Hamburg\cr
FB Wirtschaftswissenschaften\cr
Von-Melle-Park 5\cr
2000 Hamburg 13
}
\description{
A classification task for the German credit data set.
The aim is to predict creditworthiness, labeled as "good" and "bad".
Positive class is set to label "good".

See example for the creation of a \link{MeasureClassifCosts} as described misclassification costs.
}
\section{Construction}{
\preformatted{mlr_tasks$get("german_credit")
tsk("german_credit")
}
}

\examples{
task = tsk("german_credit")
costs = matrix(c(0, 1, 5, 0), nrow = 2)
dimnames(costs) = list(predicted = task$class_names, truth = task$class_names)
measure = msr("classif.costs", id = "german_credit_costs", costs = costs)
print(measure)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Task]{Tasks}: \link{mlr_tasks}
}
