% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingSubsampling.R
\docType{data}
\name{ResamplingSubsampling}
\alias{ResamplingSubsampling}
\alias{mlr_resamplings_subsampling}
\title{Subsampling Resampling}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Resampling}.}
\usage{
ResamplingSubsampling
}
\description{
\code{repeats} (default: 30) times repeated splits into training and test set
with a ratio of \code{ratio} (default: 2/3) observations in the training set.
}
\section{Fields}{

See \link{Resampling}.
}

\section{Methods}{

See \link{Resampling}.
}

\examples{
# Create a task with 10 observations
task = mlr_tasks$get("iris")
task$filter(1:10)

# Instantiate Resampling
rss = mlr_resamplings$get("subsampling",
  param_vals = list(repeats = 2, ratio = 0.5))
rss$instantiate(task)

# Individual sets:
rss$train_set(1)
rss$test_set(1)
intersect(rss$train_set(1), rss$test_set(1))

# Internal storage:
rss$instance$train # list of index vectors
}
\keyword{datasets}
