% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingCV.R
\docType{data}
\name{ResamplingCV}
\alias{ResamplingCV}
\alias{mlr_resamplings_cv}
\alias{mlr_resamplings_cv3}
\title{Cross Validation Resampling}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Resampling}.}
\usage{
ResamplingCV
}
\description{
Cross validation with \code{folds} folds (cv: 10 folds, cv3: 3 folds).
}
\section{Fields}{

See \link{Resampling}.
}

\section{Methods}{

See \link{Resampling}.
}

\examples{
# Create a task with 10 observations
task = mlr_tasks$get("iris")
task$filter(1:10)

# Instantiate Resampling
rcv = mlr_resamplings$get("cv")
rcv$param_set$values = list(folds = 3)
rcv$instantiate(task)

# Individual sets:
rcv$train_set(1)
rcv$test_set(1)
intersect(rcv$train_set(1), rcv$test_set(1))

# Internal storage:
rcv$instance # table
}
\keyword{datasets}
