% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateLearningCurve.R
\name{plotLearningCurveGGVIS}
\alias{plotLearningCurveGGVIS}
\title{Plot learning curve data using ggvis.}
\usage{
plotLearningCurveGGVIS(obj, interaction = "measure", pretty.names = TRUE)
}
\arguments{
\item{obj}{[\code{LearningCurveData}]\cr
Result of \code{\link{generateLearningCurveData}}.}

\item{interaction}{[\code{character(1)}]\cr
Selects \dQuote{measure} or \dQuote{learner} to be used in a Shiny application
making the \code{interaction} variable selectable via a drop-down menu.
This variable must have more than one unique value, otherwise it will be ignored.
The variable not chosen is mapped to color if it has more than one unique value.
Note that if there are multiple learners and multiple measures interactivity is
necessary as ggvis does not currently support facetting or subplots.
The default is \dQuote{measure}.}

\item{pretty.names}{[\code{logical(1)}]\cr
Whether to use the \code{\link{Measure}} name instead of the id in the plot.
Default is \code{TRUE}.}
}
\value{
a ggvis plot object.
}
\description{
Visualizes data size (percentage used for model) vs. performance measure(s).
}
\seealso{
Other learning_curve: \code{\link{generateLearningCurveData}},
  \code{\link{plotLearningCurve}}

Other plot: \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialDependenceGGVIS}},
  \code{\link{plotPartialDependence}},
  \code{\link{plotROCCurves}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}

