% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BenchmarkResult_operators.R
\name{getBMRModels}
\alias{getBMRModels}
\title{Extract all models from benchmark result.}
\usage{
getBMRModels(bmr, task.ids = NULL, learner.ids = NULL)
}
\arguments{
\item{bmr}{[\code{\link{BenchmarkResult}}]\cr
Benchmark result.}

\item{task.ids}{[\code{character(1)}]\cr
Restrict result to certain tasks.
Default is all.}

\item{learner.ids}{[\code{character(1)}]\cr
Restrict result to certain learners.
Default is all.}
}
\value{
[\code{list}].
}
\description{
A list of lists containing all \code{\link{WrappedModel}}s trained in the benchmark experiment.

If \code{models} is \code{FALSE} in the call to \code{\link{benchmark}}, the function will return \code{NULL}.
}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearnerShortNames}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCritDifferences}}
}

