% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotViperCharts.R
\name{plotViperCharts}
\alias{plotViperCharts}
\title{Visualize binary classification predictions via ViperCharts system.}
\usage{
plotViperCharts(obj, chart = "rocc", browse = TRUE, auth.key = NULL,
  task.id = NULL)
}
\arguments{
\item{obj}{[(list of) \code{\link{Prediction}} | (list of) \code{\link{ResampleResult}} | \code{\link{BenchmarkResult}}]\cr
Single prediction object, list of them, single resample result, list of them, or a benchmark result.
In case of a list probably produced by different learners you want to compare, then
name the list with the names you want to see in the plots, probably
learner shortnames or ids.}

\item{chart}{[\code{character(1)}]\cr
First chart to display in focus in browser.
All other charts can be displayed by clicking on the browser page menu.
Default is \dQuote{rocc}.}

\item{browse}{[\code{logical(1)}]\cr
Open ViperCharts plot in web browser? If not you simple get the URL returned.
Calls \code{\link{browseURL}}.
Default is \code{TRUE}.}

\item{auth.key}{[\code{character(1)}]\cr
API key to use for call to Viper charts website.
Only required if you want the chart to be private.
Default is \code{NULL}.}

\item{task.id}{[\code{character(1)}]\cr
Selected task in \code{\link{BenchmarkResult}} to do plots for, ignored otherwise.
Default is first task.}
}
\value{
[\code{character(1)}]. Invisibly returns the ViperCharts URL.
}
\description{
This includes ROC, lift charts, cost curves, and so on.
Please got to \url{http://viper.ijs.si} for further info.

For resampled learners, the predictions from different iterations are combined into one.
That is, for example for cross-validation, the predictions appear on
a single line even though they were made by different models. There is currently
no facility to separate the predictions for different resampling iterations.
}
\examples{
\dontrun{
lrn1 = makeLearner("classif.logreg", predict.type = "prob")
lrn2 = makeLearner("classif.rpart", predict.type = "prob")
b = benchmark(list(lrn1, lrn2), pid.task)
z = plotViperCharts(b, chart = "lift", browse = TRUE)
}
}
\references{
Sluban and Lavrač - ViperCharts: Visual Performance Evaluation Platform,
ECML PKDD 2013, pp. 650-653, LNCS 8190, Springer, 2013.
}
\seealso{
Other predict: \code{\link{asROCRPrediction}},
  \code{\link{getPredictionProbabilities}},
  \code{\link{getPredictionResponse}},
  \code{\link{predict.WrappedModel}},
  \code{\link{setPredictThreshold}},
  \code{\link{setPredictType}}

Other roc: \code{\link{asROCRPrediction}}
}

