% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTuneMultiCritResult.R
\name{plotTuneMultiCritResult}
\alias{plotTuneMultiCritResult}
\title{Plots multi-criteria results after tuning using ggplot2.}
\usage{
plotTuneMultiCritResult(res, path = TRUE, col = NULL, shape = NULL,
  pointsize = 2, pretty.names = TRUE)
}
\arguments{
\item{res}{(\link{TuneMultiCritResult})\cr
Result of \link{tuneParamsMultiCrit}.}

\item{path}{(\code{logical(1)})\cr
Visualize all evaluated points (or only the non-dominated pareto front)?
For the full path, the size of the points on the front is slightly increased.
Default is \code{TRUE}.}

\item{col}{(\code{character(1)})\cr
Which column of \code{res$opt.path} should be mapped to ggplot2 color?
Default is \code{NULL}, which means none.}

\item{shape}{(\code{character(1)})\cr
Which column of \code{res$opt.path} should be mapped to ggplot2 shape?
Default is \code{NULL}, which means none.}

\item{pointsize}{(\code{numeric(1)})\cr
Point size for ggplot2 \link[ggplot2:geom_point]{ggplot2::geom_point} for data points.
Default is 2.}

\item{pretty.names}{(\code{logical(1)})\cr
Whether to use the ID of the measures instead of their name in labels. Defaults to \code{TRUE}.}
}
\value{
ggplot2 plot object.
}
\description{
Visualizes the pareto front and possibly the dominated points.
}
\examples{
# see tuneParamsMultiCrit
}
\seealso{
Other tune_multicrit: \code{\link{TuneMultiCritControl}},
  \code{\link{tuneParamsMultiCrit}}
}
\concept{tune_multicrit}
