% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreprocWrapperCaret.R
\name{makePreprocWrapperCaret}
\alias{makePreprocWrapperCaret}
\title{Fuse learner with preprocessing.}
\usage{
makePreprocWrapperCaret(learner, ...)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}

\item{...}{(any)\cr
See \link[caret:preProcess]{caret::preProcess} for parameters not listed above.
If you use them you might want to define them in the \code{add.par.set} so that they can be tuned.}
}
\value{
\link{Learner}.
}
\description{
Fuses a learner with preprocessing methods provided by \link[caret:preProcess]{caret::preProcess}.
Before training the preprocessing will be performed and the preprocessing model will be stored.
Before prediction the preprocessing model will transform the test data according to the trained model.

After being wrapped the learner will support missing values although this will only be the case if \code{ppc.knnImpute}, \code{ppc.bagImpute} or \code{ppc.medianImpute} is set to \code{TRUE}.
}
\seealso{
Other wrapper: \code{\link{makeBaggingWrapper}},
  \code{\link{makeClassificationViaRegressionWrapper}},
  \code{\link{makeConstantClassWrapper}},
  \code{\link{makeCostSensClassifWrapper}},
  \code{\link{makeCostSensRegrWrapper}},
  \code{\link{makeDownsampleWrapper}},
  \code{\link{makeDummyFeaturesWrapper}},
  \code{\link{makeExtractFDAFeatsWrapper}},
  \code{\link{makeFeatSelWrapper}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeImputeWrapper}},
  \code{\link{makeMulticlassWrapper}},
  \code{\link{makeMultilabelBinaryRelevanceWrapper}},
  \code{\link{makeMultilabelClassifierChainsWrapper}},
  \code{\link{makeMultilabelDBRWrapper}},
  \code{\link{makeMultilabelNestedStackingWrapper}},
  \code{\link{makeMultilabelStackingWrapper}},
  \code{\link{makeOverBaggingWrapper}},
  \code{\link{makePreprocWrapper}},
  \code{\link{makeRemoveConstantFeaturesWrapper}},
  \code{\link{makeSMOTEWrapper}},
  \code{\link{makeTuneWrapper}},
  \code{\link{makeUndersampleWrapper}},
  \code{\link{makeWeightedClassesWrapper}}
}
