% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateFilterValues.R
\name{plotFilterValuesGGVIS}
\alias{plotFilterValuesGGVIS}
\title{Plot filter values using ggvis.}
\usage{
plotFilterValuesGGVIS(fvalues, feat.type.cols = FALSE)
}
\arguments{
\item{fvalues}{[\code{\link{FilterValues}}]\cr
Filter values.}

\item{feat.type.cols}{[\code{logical(1)}]\cr
Colors for factor and numeric features.
\code{FALSE} means no colors.
Default is \code{FALSE}.}
}
\value{
a ggvis plot object.
}
\description{
Plot filter values using ggvis.
}
\examples{
\dontrun{
fv = generateFilterValuesData(iris.task, method = "variance")
plotFilterValuesGGVIS(fv)
}
}
\seealso{
Other plot: \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialDependenceGGVIS}},
  \code{\link{plotPartialDependence}},
  \code{\link{plotROCCurves}}, \code{\link{plotResiduals}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}

Other filter: \code{\link{filterFeatures}},
  \code{\link{generateFilterValuesData}},
  \code{\link{getFilterValues}},
  \code{\link{getFilteredFeatures}},
  \code{\link{makeFilterWrapper}},
  \code{\link{plotFilterValues}}
}
