% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_scale.R
\name{preprocess_scale}
\alias{preprocess_scale}
\title{Scale Data}
\usage{
preprocess_scale(
  input,
  epsilon = NA,
  input_model = NA,
  inverse_scaling = FALSE,
  max_value = NA,
  min_value = NA,
  scaler_method = NA,
  seed = NA,
  verbose = FALSE
)
}
\arguments{
\item{input}{Matrix containing data (numeric matrix).}

\item{epsilon}{regularization Parameter for pcawhitening, or
zcawhitening, should be between -1 to 1.  Default value "1e-06" (numeric).}

\item{input_model}{Input Scaling model (ScalingModel).}

\item{inverse_scaling}{Inverse Scaling to get original datase.  Default
value "FALSE" (logical).}

\item{max_value}{Ending value of range for min_max_scaler.  Default
value "1" (integer).}

\item{min_value}{Starting value of range for min_max_scaler.  Default
value "0" (integer).}

\item{scaler_method}{method to use for scaling, the default is
standard_scaler.  Default value "standard_scaler" (character).}

\item{seed}{Random seed (0 for std::time(NULL)).  Default value "0"
(integer).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value "FALSE"
(logical).}
}
\value{
A list with several components:
\item{output}{Matrix to save scaled data to (numeric matrix).}
\item{output_model}{Output scaling model (ScalingModel).}
}
\description{
A utility to perform feature scaling on datasets using one of sixtechniques. 
Both scaling and inverse scaling are supported, andscalers can be saved and
then applied to other datasets.
}
\details{
This utility takes a dataset and performs feature scaling using one of the
six scaler methods namely: 'max_abs_scaler', 'mean_normalization',
'min_max_scaler' ,'standard_scaler', 'pca_whitening' and 'zca_whitening'. The
function takes a matrix as "input" and a scaling method type which you can
specify using "scaler_method" parameter; the default is standard scaler, and
outputs a matrix with scaled feature.

The output scaled feature matrix may be saved with the "output" output
parameters.

The model to scale features can be saved using "output_model" and later can
be loaded back using"input_model".
}
\examples{
# So, a simple example where we want to scale the dataset "X" into "X_scaled"
# with  standard_scaler as scaler_method, we could run 

\dontrun{
output <- preprocess_scale(input=X, scaler_method="standard_scaler")
X_scaled <- output$output
}

# A simple example where we want to whiten the dataset "X" into "X_whitened"
# with  PCA as whitening_method and use 0.01 as regularization parameter, we
# could run 

\dontrun{
output <- preprocess_scale(input=X, scaler_method="pca_whitening",
  epsilon=0.01)
X_scaled <- output$output
}

# You can also retransform the scaled dataset back using"inverse_scaling". An
# example to rescale : "X_scaled" into "X"using the saved model "input_model"
# is:

\dontrun{
output <- preprocess_scale(input=X_scaled, inverse_scaling=TRUE,
  input_model=saved)
X <- output$output
}

# Another simple example where we want to scale the dataset "X" into
# "X_scaled" with  min_max_scaler as scaler method, where scaling range is 1
# to 3 instead of default 0 to 1. We could run 

\dontrun{
output <- preprocess_scale(input=X, scaler_method="min_max_scaler",
  min_value=1, max_value=3)
X_scaled <- output$output
}
}
\author{
mlpack developers
}
