/**
 * @file src/lsh.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R lsh binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/lsh/lsh_main.cpp>

// [[Rcpp::export]]
void lsh_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a LSHSearch<> parameter.
// [[Rcpp::export]]
SEXP IO_GetParamLSHSearchPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<LSHSearch<>>) IO::GetParam<LSHSearch<>*>(paramName));
}

// Set the pointer to a LSHSearch<> parameter.
// [[Rcpp::export]]
void IO_SetParamLSHSearchPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<LSHSearch<>*>(paramName) =  Rcpp::as<Rcpp::XPtr<LSHSearch<>>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a LSHSearch<> pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeLSHSearchPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("LSHSearch",
          *Rcpp::as<Rcpp::XPtr<LSHSearch<>>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "LSHSearch";
  return raw_vec;
}

// Deserialize a LSHSearch<> pointer.
// [[Rcpp::export]]
SEXP DeserializeLSHSearchPtr(Rcpp::RawVector str)
{
  LSHSearch<>* ptr = new LSHSearch<>();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("LSHSearch", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<LSHSearch<>>)ptr);
}


