/**
 * @file src/knn.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R knn binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/neighbor_search/knn_main.cpp>

// [[Rcpp::export]]
void knn_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a KNNModel parameter.
// [[Rcpp::export]]
SEXP IO_GetParamKNNModelPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<KNNModel>) IO::GetParam<KNNModel*>(paramName));
}

// Set the pointer to a KNNModel parameter.
// [[Rcpp::export]]
void IO_SetParamKNNModelPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<KNNModel*>(paramName) =  Rcpp::as<Rcpp::XPtr<KNNModel>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a KNNModel pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeKNNModelPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("KNNModel",
          *Rcpp::as<Rcpp::XPtr<KNNModel>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "KNNModel";
  return raw_vec;
}

// Deserialize a KNNModel pointer.
// [[Rcpp::export]]
SEXP DeserializeKNNModelPtr(Rcpp::RawVector str)
{
  KNNModel* ptr = new KNNModel();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("KNNModel", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<KNNModel>)ptr);
}


