% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_swmd.R
\encoding{UTF-8}
\name{dis_swmd}
\alias{dis_swmd}
\title{Constructs a pairwise distance matrix based on VPCA and SWMD}
\usage{
dis_swmd(X, var_rate = 0.9, features = FALSE)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{var_rate}{Rate of retained variability concerning the
dimensionality-reduced MTS samples (default is 0.90).}

\item{features}{Logical. If \code{features = FALSE} (default), a distance matrix is returned. Otherwise, the function
returns a dataset of feature vectors.}
}
\value{
If \code{features = FALSE} (default), returns a distance matrix based on the distance \eqn{d_{SWMD}}. Otherwise, the function
returns a dataset of feature vectors, i.e., each row in the dataset contains the features employed to compute the
distance \eqn{d_{SWMD}}.
}
\description{
\code{dis_swmd} returns a pairwise distance matrix based on variable-based
principal component analysis (VPCA) and a spatial weighted matrix distance
(SWMD) \insertCite{he2018unsupervised}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS \eqn{\boldsymbol X_T} and \eqn{\boldsymbol Y_T} is defined
as  \deqn{d_{SWMD}(\boldsymbol X_T, \boldsymbol Y_T)=\Big[\big(vec
(\boldsymbol Z^{\boldsymbol X_T})-vec(\boldsymbol Z^{\boldsymbol Y_T})\big)\boldsymbol
S\big(vec(\boldsymbol Z^{\boldsymbol X_T})-vec(\boldsymbol Z^{\boldsymbol Y_T})\big)^\top\Big]^{1/2},}
where \eqn{\boldsymbol Z^{\boldsymbol X_T}} and \eqn{\boldsymbol Z^{\boldsymbol Y_T}} are the dimensionality-
reduced MTS samples associated with \eqn{\boldsymbol X_T} and
\eqn{\boldsymbol Y_T}, respectively, the operator \eqn{vec(\cdot)}
creates a vector by concatenating the columns of the matrix received as input
and \eqn{\boldsymbol S} is a matrix integrating the spatial dimensionality
difference between the corresponding elements.
}
\examples{
toy_dataset <- AtrialFibrillation$data[1 : 10] # Selecting the first 10 MTS from the
# dataset AtrialFibrillation
distance_matrix <- dis_swmd(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_swmd
feature_dataset <- dis_swmd(toy_dataset, features = TRUE) # Computing
# the corresponding dataset of features
}
\references{
{

  \insertRef{he2018unsupervised}{mlmts}

}
}
\seealso{
\code{\link{vpca_clustering}}
}
\author{
Ángel López-Oriona, José A. Vilar
}
