% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_www.R
\encoding{UTF-8}
\name{dis_www}
\alias{dis_www}
\title{Constructs a pairwise distance matrix based on feature extraction}
\usage{
dis_www(X, h = 20, features = FALSE)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{h}{Maximum lag for the computation of the Box-Pierce statistic.}

\item{features}{Logical. If \code{features = FALSE} (default), a distance matrix is returned. Otherwise, the function
returns a dataset of feature vectors.}
}
\value{
If \code{features = FALSE} (default), returns a distance matrix based on the distance \eqn{d_{WWW}}. Otherwise, the function
returns a dataset of feature vectors, i.e., each row in the dataset contains the features employed to compute the
distance \eqn{d_{WWW}}.
}
\description{
\code{dis_www} returns a pairwise distance matrix based on the feature
extraction procedure proposed by \insertCite{wang2007structure;textual}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS is defined as the Euclidean distance
between the corresponding feature vectors
}
\examples{
toy_dataset <- AtrialFibrillation$data[1 : 10] # Selecting the first 10 MTS from the
# dataset AtrialFibrillation
distance_matrix <- dis_www(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_www
feature_dataset <- dis_www(toy_dataset, features = TRUE) # Computing
# the corresponding dataset of features
}
\references{
{

  \insertRef{wang2007structure}{mlmts}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
