#' Instruction Data
#'
#' Data from a QTL experiment on gravitropism in
#' Arabidopsis, with data on 162 recombinant inbred lines (Ler x
#' Cvi). The outcome is the root tip angle (in degrees) at two-minute
#' increments over eight hours.
#'
#' @docType data
#'
#' @usage data(instruction)
#'
#' @format A data frame with 1190 observations on the following 8 variables.
#' \describe{
#' \item{\code{female}}{Dummy variable for being female}
#' \item{\code{mathkind}}{Math achievement score in the spring of kindergarten}
#' \item{\code{mathgain}}{Gain in math achievement score from spring of kindergarten to spring of first grade}
#' \item{\code{ses}}{Socioeconomic status}
#' \item{\code{mathprep}}{First grade teacher's mathematic preparation (based on number of courses taken)}
#' \item{\code{classid}}{Classroom identifier}
#' \item{\code{schoolid}}{School identifier}
#' \item{\code{childid}}{Student identifier}
#' }
#'
#'
#' @keywords datasets
#'
#' @references Rabe-Hesketh, Sophia, and Brian Everitt. Handbook of statistical analyses using Stata. CRC Press, 2003.
#'
#' @source \href{https://www.stata-press.com/data/mlmus3/instruction.dta}{Stata Press}
#'
#' @examples
#' data(instruction)
"instruction"
