% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{parameters}
\alias{parameters}
\alias{parameters.mp_model}
\alias{parameters.mp_data}
\alias{parameters.mp_power}
\title{Obtain \code{\link{mp_parameters}} from objects}
\usage{
parameters(object)

\method{parameters}{mp_model}(object)

\method{parameters}{mp_data}(object)

\method{parameters}{mp_power}(object)
}
\arguments{
\item{object}{an object which the \code{\link{mp_parameters}} are desired.}
}
\value{
A \code{\link{mp_parameters}} object
}
\description{
A generic function to obtain \code{\link{mp_parameters}} from defined models and data sets.
}
\details{
Currently object can be:
\itemize{
\item \code{\link{mp_model}}
\item \code{\link{mp_data}}
\item \code{\link{mp_power}}
}

If using on a  \code{\link{mp_model}} and the  model has random correlations
then the average is used.
}
\examples{
# Create Model
model <- (
    outcome('Y')
    + within_predictor('X')
    + effect_size(icc = 0.1)
)

# Create data set and obtain population parameters
model |> parameters()
# Set seed
set.seed(198723)
# Create data set and obtain population parameters
model |> generate(5, 50) |> parameters()
# Set seed
set.seed(198723)
# Create data set and obtain population parameters
model |> power_analysis(50, 5, 50) |> parameters()
}
