% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center.R
\name{center}
\alias{center}
\title{Automatically grand-mean or group-mean center a fitted object}
\usage{
center(
  x,
  grand_variables = NULL,
  group = NULL,
  group_variables = NULL,
  value = NULL,
  value_variables = NULL
)
}
\arguments{
\item{x}{A model produced using the \code{lme4::lmer()} function. This is an object of class \code{merMod} and subclass \code{lmerMod}.}

\item{grand_variables}{one or more variables to center at the grand-mean}

\item{group}{Grouping variable. If a grouping variable is specified, group-mean centering (also known as centering within cluster) based on that variable will be performed.}

\item{group_variables}{Variables to be group-mean centered.}

\item{value}{Center at a specific value rather than the grand mean}

\item{value_variables}{Variables to be centered at user-specified value rather than the grand mean}
}
\value{
A newly fitted model with centered variables
}
\description{
This function refits a model using grand-mean centering, group-mean centering (if a grouping variable is specified), or centering at a user-specified value
}
\examples{

fit <- lme4::lmer(mathach ~ 1 + ses + catholic + (1|id),
data=hsb, REML=TRUE)

# Centering a single variable around the grand mean
fit_gmc <- center(fit, grand_variables="ses")

# Centering multiple variables around the grand mean
fit_gmc <- center(fit, grand_variables=c("ses", "catholic"))

# Centering variables around the group means
fit_cwg <- center(fit, group="id", group_variables="ses")

# Centering variables using different strategies
fit_mixed <- center(fit, group = "id", group_variables = "ses", grand_variables = "catholic")
}
