% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_se.R
\name{boot_se}
\alias{boot_se}
\title{Bootstrap Standard Errors (experimental)}
\usage{
boot_se(model, nsim = 5, seed = 1234, pct = 95, ...)
}
\arguments{
\item{model}{a mixed model produced using the \code{lme4} package (\code{lmer} or \code{glmer} functions). This is an object of class \code{merMod}. This function is a wrapper for \code{lme4::bootMer}}

\item{nsim}{number of bootstrap samples to compute. Defaults to 5 but should be closer to 1,000 or 5,000. Note this is time intensive.}

\item{seed}{random number seed for reproducibility. Defaults to 1234.}

\item{pct}{percentage level for confidence interval. Defaults to 95.}

\item{...}{additional parameters to pass to \code{lme4::bootMer}. Not currently implemented.}
}
\value{
A list containing a data frame with coefficient estimates and number of bootstrapped samples.
}
\description{
Computes bootstrapped standard errors for fixed effects. z-test returned using a standard normal reference distribution (interpret with caution)
}
\examples{

# lmer example
fit <- lme4::lmer(mathach ~ 1 + ses + catholic + (1|id),
data=hsb, REML=TRUE)

boot_se(fit)

\donttest{

# run time > 10s
# glmer example: logistic
  # Create binary outcome
hsb$binary_math <- ifelse(hsb$mathach <= 13, 0, 1)

fitb <- lme4::glmer(binary_math ~ 1 + ses + catholic + (1|id),
data=hsb, family = binomial(link="logit"))

boot_se(fitb)
}

}
