% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_fit.R, R/ml_fit_dss.R, R/ml_fit_entropy_o.R,
%   R/ml_fit_hipf.R, R/ml_fit_ipu.R
\name{ml_fit}
\alias{ml_fit}
\alias{is_ml_fit}
\alias{format.ml_fit}
\alias{print.ml_fit}
\alias{ml_fit_dss}
\alias{ml_fit_entropy_o}
\alias{ml_fit_hipf}
\alias{ml_fit_ipu}
\title{Estimate weights for a fitting problem}
\usage{
ml_fit(
  ml_problem,
  algorithm = c("entropy_o", "dss", "ipu", "hipf"),
  verbose = FALSE,
  ...,
  tol = 1e-06
)

is_ml_fit(x)

\method{format}{ml_fit}(x, ...)

\method{print}{ml_fit}(x, ...)

ml_fit_dss(
  ml_problem,
  method = c("raking", "linear", "logit"),
  ginv = gginv(),
  tol = 1e-06,
  verbose = FALSE
)

ml_fit_entropy_o(
  ml_problem,
  verbose = FALSE,
  tol = 1e-06,
  dfsane_args = list()
)

ml_fit_hipf(
  ml_problem,
  diff_tol = 16 * .Machine$double.eps,
  tol = 1e-06,
  maxiter = 2000,
  verbose = FALSE
)

ml_fit_ipu(
  ml_problem,
  diff_tol = 16 * .Machine$double.eps,
  tol = 1e-06,
  maxiter = 2000,
  verbose = FALSE
)
}
\arguments{
\item{ml_problem}{A fitting problem created by
\code{\link[=ml_problem]{ml_problem()}} or returned by \code{\link[=flatten_ml_fit_problem]{flatten_ml_fit_problem()}}.}

\item{algorithm}{Algorithm to use}

\item{verbose}{If \code{TRUE}, print diagnostic output.}

\item{...}{Further parameters passed to the algorithm}

\item{tol}{Tolerance, the algorithm has succeeded when all target values are
reached within this tolerance.}

\item{x}{An object}

\item{method}{Calibration method, one of \code{"raking"} (default),
\code{"linear"}, or \code{"logit"}}

\item{ginv}{Function that computes the Moore-Penrose pseudoinverse.}

\item{dfsane_args}{Additional arguments (as a named list) passed to the
\code{\link[BB:dfsane]{BB::dfsane()}} function used internally for the optimization.}

\item{diff_tol}{Tolerance, the algorithm stops when relative difference of
control values between iterations drops below this value}

\item{maxiter}{Maximum number of iterations.}
}
\value{
All functions return an object of class \code{ml_fit}, which is
a named list under the hood.  The class matches the function called,
e.g., the return value of the \code{ml_fit_ipu} function also is of class
\code{ml_fit_ipu}.

All returned objects contain at least the following components, which can be
accessed with \code{$} or \code{[[}:
\itemize{
\item \code{weights}: Resulting weights, compatible to the original reference sample
\item \code{tol}: The input tolerance
\item \code{iterations}: The actual number of iterations required to obtain the result
\item \code{flat}: The flattened fitting problem, see \code{flatten_ml_fit_problem()}
\item \code{flat_weights}: Weights in terms of the flattened fitting problem
\item \code{residuals}: Absolute residuals
}

\itemize{
\item \code{rel_residuals}: Relative residuals
\item \code{success}: Are the residuals within the tolerance?
}

\code{is_ml_fit()} returns a logical.
}
\description{
These functions reweight a reference sample to match constraints given by
aggregate controls.

\code{ml_fit()} accepts an algorithm as argument and calls the
corresponding function. This is useful if the result of multiple algorithms
are compared to each other.
}
\examples{
path <- toy_example("Tiny")
fit <- ml_fit(ml_problem = readRDS(path), algorithm = "entropy_o")
fit
fit$weights
fit$tol
fit$iterations
fit$flat
fit$flat_weights
fit$residuals
fit$rel_residuals
fit$success
ml_fit_dss(ml_problem = readRDS(path))
ml_fit_dss(ml_problem = readRDS(path), ginv = solve)
ml_fit_entropy_o(ml_problem = readRDS(path))
ml_fit_hipf(ml_problem = readRDS(path))
ml_fit_ipu(ml_problem = readRDS(path))
}
\references{
Deville, J.-C. and \enc{Särndal}{Saerndal}, C.-E. (1992)
Calibration estimators in survey sampling. \emph{Journal of the American
Statistical Association}, \strong{87} (418), 376--382.

Deville, J.-C., \enc{Särndal}{Saerndal}, C.-E. and Sautory, O. (1993)
Generalized raking procedures in survey sampling. \emph{Journal of the
American Statistical Association}, \strong{88} (423), 1013--1020.

Bar-Gera, H., Konduri, K. C., Sana, B., Ye, X., & Pendyala, R. M.
(2009, January). Estimating survey weights with multiple
constraints using entropy optimization methods. In 88th Annual
Meeting of the Transportation Research Board, Washington, DC.

Müller, K. and Axhausen, K. W. (2011), Hierarchical IPF: Generating a
synthetic population for Switzerland, paper presented at the 51st
Congress of the European Regional Science Association, University of
Barcelona, Barcelona.

Ye, X., K. Konduri, R. M. Pendyala, B. Sana and P. A. Waddell (2009)
A methodology to match distributions of both household and person attributes
in the generation of synthetic populations, paper presented at the \emph{88th
Annual Meeting of the Transportation Research Board}, Washington, D.C.,
January 2009.
}
\seealso{
\code{\link[=dss]{dss()}}, \code{\link[=gginv]{gginv()}}

\code{\link[BB:dfsane]{BB::dfsane()}}
}
