% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mmkin.R
\name{plot.mmkin}
\alias{plot.mmkin}
\title{Plot model fits (observed and fitted) and the residuals for a row or column
of an mmkin object}
\usage{
\method{plot}{mmkin}(
  x,
  main = "auto",
  legends = 1,
  resplot = c("time", "errmod"),
  show_errmin = TRUE,
  errmin_var = "All data",
  errmin_digits = 3,
  cex = 0.7,
  rel.height.middle = 0.9,
  ymax = "auto",
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{mmkin}}, with either one row or one
column.}

\item{main}{The main title placed on the outer margin of the plot.}

\item{legends}{An index for the fits for which legends should be shown.}

\item{resplot}{Should the residuals plotted against time, using
\code{\link{mkinresplot}}, or as squared residuals against predicted
values, with the error model, using \code{\link{mkinerrplot}}.}

\item{show_errmin}{Should the chi2 error level be shown on top of the plots
to the left?}

\item{errmin_var}{The variable for which the FOCUS chi2 error value should
be shown.}

\item{errmin_digits}{The number of significant digits for rounding the FOCUS
chi2 error percentage.}

\item{cex}{Passed to the plot functions and \code{\link{mtext}}.}

\item{rel.height.middle}{The relative height of the middle plot, if more
than two rows of plots are shown.}

\item{ymax}{Maximum y axis value for \code{\link{plot.mkinfit}}.}

\item{\dots}{Further arguments passed to \code{\link{plot.mkinfit}} and
\code{\link{mkinresplot}}.}
}
\value{
The function is called for its side effect.
}
\description{
When x is a row selected from an mmkin object (\code{\link{[.mmkin}}), the
same model fitted for at least one dataset is shown. When it is a column,
the fit of at least one model to the same dataset is shown.
}
\details{
If the current plot device is a \code{\link[tikzDevice]{tikz}} device, then
latex is being used for the formatting of the chi2 error level.
}
\examples{

  \dontrun{
  # Only use one core not to offend CRAN checks
  fits <- mmkin(c("FOMC", "HS"),
                list("FOCUS B" = FOCUS_2006_B, "FOCUS C" = FOCUS_2006_C), # named list for titles
                cores = 1, quiet = TRUE, error_model = "tc")
  plot(fits[, "FOCUS C"])
  plot(fits["FOMC", ])

  # We can also plot a single fit, if we like the way plot.mmkin works, but then the plot
  # height should be smaller than the plot width (this is not possible for the html pages
  # generated by pkgdown, as far as I know).
  plot(fits["FOMC", "FOCUS C"]) # same as plot(fits[1, 2])

  # Show the error models
  plot(fits["FOMC", ], resplot = "errmod")
  }

}
\author{
Johannes Ranke
}
